// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 55 1.5.1.4 source/core/collect/issbst.h, collection, ioc.v400, 980918 
#ifndef _ISSBST_
#define _ISSBST_

#include <ilanglvl.hpp>
#include <iass.h>
#include <iicss.h>

#include <iivss.h>

#include <iissbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedSetAsBstTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedSetAsBstTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedSetAsBstTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsBstTreeCursor
                            (IGSortedSetAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsBstTreeCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsBstTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsBstTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedSetAsBstTree :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsBstTree <Element, ElementOps> Self;

  typedef  ISortedSetAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISortedSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsBstTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedSetAsBstTreeCursor
            <Element, ElementOps> Cursor;




           IGSortedSetAsBstTree
                            (INumber = 100);

           IGSortedSetAsBstTree
                            (IGSortedSetAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsBstTree <Element, ElementOps>&
           operator=        (IGSortedSetAsBstTree
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedSetAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsBstTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsBstTreeCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedSetAsBstTree :
  public IGSortedSetAsBstTree
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedSetAsBstTree <Element> Self;

#define ISortedSetAsBstTreeTypedef(Element)\
  typedef  ISortedSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedSetAsBstTree
                            (INumber = 100);

















protected:

           ISortedSetAsBstTree
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedSetAsBstTree :
  public IGSortedSetAsBstTree
          <Element, ElementOps > {

  typedef  IVGSortedSetAsBstTree
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedSetAsBstTree
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISortedSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsBstTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedSetAsBstTree
                            (INumber = 100);

















protected:

           IVGSortedSetAsBstTree
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedSetAsBstTree :
  public IVGSortedSetAsBstTree
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedSetAsBstTree <Element> Self;

#define IVSortedSetAsBstTreeTypedef(Element)\
  typedef  IVSortedSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedSetAsBstTree
                            (INumber = 100);

















protected:

           IVSortedSetAsBstTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <issbst.inl>


#pragma info (restore)


#endif // _ISSBST_
