// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 53 1.5.1.4 source/core/collect/issavl.h, collection, ioc.v400, 980918 
#ifndef _ISSAVL_
#define _ISSAVL_

#include <ilanglvl.hpp>
#include <iass.h>
#include <iicss.h>

#include <iivss.h>

#include <iissavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedSetAsAvlTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedSetAsAvlTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedSetAsAvlTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsAvlTreeCursor
                            (IGSortedSetAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsAvlTreeCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsAvlTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsAvlTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedSetAsAvlTree :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsAvlTree <Element, ElementOps> Self;

  typedef  ISortedSetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedSetAsAvlTreeCursor
            <Element, ElementOps> Cursor;




           IGSortedSetAsAvlTree
                            (INumber = 100);

           IGSortedSetAsAvlTree
                            (IGSortedSetAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsAvlTree <Element, ElementOps>&
           operator=        (IGSortedSetAsAvlTree
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedSetAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsAvlTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsAvlTreeCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedSetAsAvlTree :
  public IGSortedSetAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedSetAsAvlTree <Element> Self;

#define ISortedSetAsAvlTreeTypedef(Element)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedSetAsAvlTree
                            (INumber = 100);

















protected:

           ISortedSetAsAvlTree
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedSetAsAvlTree :
  public IGSortedSetAsAvlTree
          <Element, ElementOps > {

  typedef  IVGSortedSetAsAvlTree
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedSetAsAvlTree
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedSetAsAvlTree
                            (INumber = 100);

















protected:

           IVGSortedSetAsAvlTree
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedSetAsAvlTree :
  public IVGSortedSetAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedSetAsAvlTree <Element> Self;

#define IVSortedSetAsAvlTreeTypedef(Element)\
  typedef  IVSortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedSetAsAvlTree
                            (INumber = 100);

















protected:

           IVSortedSetAsAvlTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <issavl.inl>


#pragma info (restore)


#endif // _ISSAVL_
