#ifndef _ISS2_
  #define _ISS2_
/*******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>

#ifdef IC_USE_STL
  #include <iset2.h>

  template <class Element, class Imp>
    class ITImpSortedSet : public ITImpSet<Element, Imp>
  {
  public:
    ITImpSortedSet( unsigned long numberOfElements = 100);
    ~ITImpSortedSet();
  };

  template <class Element>
    class ISortedSet : public ITImpSortedSet<Element, Element>
  {
    public:
    ISortedSet( unsigned long numberOfElements = 100);
   ~ISortedSet();
  };


  #ifdef IC_USE_STL_VPTR
    template <class Element>
      class IVPtrSortedSet : public ITImpSortedSet<Element, void*>
    {
      public:
      IVPtrSortedSet( unsigned long numberOfElements = 100);
     ~IVPtrSortedSet();
    };
  #else
    #define IVPtrSortedSet ISortedSet
  #endif

  #ifndef __TEMPINC__
    #include <iss2.c>
  #endif

#else
  #include <iss.h>
  #define IVPtrSortedSet ISortedSet
#endif

#endif // _ISS2_

