// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 51 1.5.1.4 source/core/collect/iss.h, collection, ioc.v400, 980918 
#ifndef _ISS_
#define _ISS_

#include <ilanglvl.hpp>
#include <iass.h>
#include <iicss.h>

#include <iivss.h>

#include <iissavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedSet;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedSetCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedSet
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetCursor
                            (IGSortedSet
                              <
                               Element, ElementOps> const&);

  IGSortedSetCursor <Element, ElementOps>&
           operator=        (IGSortedSetCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedSet :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSet <Element, ElementOps> Self;

  typedef  ISortedSetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetTypedef(Element, ElementOps)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedSetCursor
            <Element, ElementOps> Cursor;




           IGSortedSet
                            (INumber = 100);

           IGSortedSet
                            (IGSortedSet
                              <
                               Element, ElementOps> const&);

  IGSortedSet <Element, ElementOps>&
           operator=        (IGSortedSet
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedSet
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSet
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedSet :
  public IGSortedSet
          <Element, ICOps <Element> > {

  typedef  IGSortedSet
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedSet <Element> Self;

#define ISortedSetTypedef(Element)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedSet
                            (INumber = 100);

















protected:

           ISortedSet
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedSet :
  public IGSortedSet
          <Element, ElementOps > {

  typedef  IVGSortedSet
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedSet
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetTypedef(Element, ElementOps)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedSet
                            (INumber = 100);

















protected:

           IVGSortedSet
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedSet :
  public IVGSortedSet
          <Element, ICOps <Element> > {

  typedef  IVGSortedSet
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedSet <Element> Self;

#define IVSortedSetTypedef(Element)\
  typedef  IVSortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedSet
                            (INumber = 100);

















protected:

           IVSortedSet
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iss.inl>


#pragma info (restore)


#endif // _ISS_
