// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 45 1.5.1.4 source/core/collect/isrtab.h, collection, ioc.v400, 980918 
#ifndef _ISRTAB_
#define _ISRTAB_

#include <ilanglvl.hpp>
#include <iasr.h>
#include <iicsr.h>

#include <iivsr.h>

#include <iisrtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedRelationAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedRelationAsTableCursor
                            (IGSortedRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedRelationAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedRelationAsTable :
  public IASortedRelation <Element, Key> {
protected:

  typedef  IGSortedRelationAsTable <Element, Key, ElementOps> Self;

  typedef  ISortedRelationAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedRelationAsTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedRelationAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedRelationAsTableCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedRelationAsTable
                            (INumber = 100);

           IGSortedRelationAsTable
                            (IGSortedRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsTable <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedRelationAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedRelationAsTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedRelationAsTable :
  public IGSortedRelationAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedRelationAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedRelationAsTable <Element, Key> Self;

#define ISortedRelationAsTableTypedef(Element, Key)\
  typedef  ISortedRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedRelationAsTable
                            (INumber = 100);

















protected:

           ISortedRelationAsTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedRelationAsTable :
  public IGSortedRelationAsTable
          <Element, Key, ElementOps > {

  typedef  IVGSortedRelationAsTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedRelationAsTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedRelationImpl
            <IVSortedRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedRelationAsTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedRelationAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedRelationAsTable
                            (INumber = 100);

















protected:

           IVGSortedRelationAsTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedRelationAsTable :
  public IVGSortedRelationAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedRelationAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedRelationAsTable <Element, Key> Self;

#define IVSortedRelationAsTableTypedef(Element, Key)\
  typedef  IVSortedRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedRelationAsTable
                            (INumber = 100);

















protected:

           IVSortedRelationAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isrtab.inl>


#pragma info (restore)


#endif // _ISRTAB_
