// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 40 1.5.1.4 source/core/collect/isrlst.h, collection, ioc.v400, 980918 
#ifndef _ISRLST_
#define _ISRLST_

#include <ilanglvl.hpp>
#include <iasr.h>
#include <iicsr.h>

#include <iivsr.h>

#include <iisrlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedRelationAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedRelationAsListCursor
                            (IGSortedRelationAsList
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsListCursor <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedRelationAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedRelationAsList :
  public IASortedRelation <Element, Key> {
protected:

  typedef  IGSortedRelationAsList <Element, Key, ElementOps> Self;

  typedef  ISortedRelationAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedRelationAsListTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedRelationAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedRelationAsListCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedRelationAsList
                            (INumber = 100);

           IGSortedRelationAsList
                            (IGSortedRelationAsList
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsList <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsList
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedRelationAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedRelationAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedRelationAsListCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedRelationAsList :
  public IGSortedRelationAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedRelationAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedRelationAsList <Element, Key> Self;

#define ISortedRelationAsListTypedef(Element, Key)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedRelationAsList
                            (INumber = 100);

















protected:

           ISortedRelationAsList
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedRelationAsList :
  public IGSortedRelationAsList
          <Element, Key, ElementOps > {

  typedef  IVGSortedRelationAsList
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedRelationAsList
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedRelationImpl
            <IVSortedRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedRelationAsListTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedRelationAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedRelationAsList
                            (INumber = 100);

















protected:

           IVGSortedRelationAsList
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedRelationAsList :
  public IVGSortedRelationAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedRelationAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedRelationAsList <Element, Key> Self;

#define IVSortedRelationAsListTypedef(Element, Key)\
  typedef  IVSortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedRelationAsList
                            (INumber = 100);

















protected:

           IVSortedRelationAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isrlst.inl>


#pragma info (restore)


#endif // _ISRLST_
