// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 38 1.5.1.4 source/core/collect/isrdil.h, collection, ioc.v400, 980918 
#ifndef _ISRDIL_
#define _ISRDIL_

#include <ilanglvl.hpp>
#include <iasr.h>
#include <iicsr.h>

#include <iivsr.h>

#include <iisrdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedRelationAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedRelationAsDilTableCursor
                            (IGSortedRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedRelationAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedRelationAsDilTable :
  public IASortedRelation <Element, Key> {
protected:

  typedef  IGSortedRelationAsDilTable <Element, Key, ElementOps> Self;

  typedef  ISortedRelationAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedRelationAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedRelationAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedRelationAsDilTableCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedRelationAsDilTable
                            (INumber = 100);

           IGSortedRelationAsDilTable
                            (IGSortedRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsDilTable <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedRelationAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedRelationAsDilTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedRelationAsDilTable :
  public IGSortedRelationAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedRelationAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedRelationAsDilTable <Element, Key> Self;

#define ISortedRelationAsDilTableTypedef(Element, Key)\
  typedef  ISortedRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedRelationAsDilTable
                            (INumber = 100);

















protected:

           ISortedRelationAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedRelationAsDilTable :
  public IGSortedRelationAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGSortedRelationAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedRelationAsDilTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedRelationImpl
            <IVSortedRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedRelationAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedRelationAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedRelationAsDilTable
                            (INumber = 100);

















protected:

           IVGSortedRelationAsDilTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedRelationAsDilTable :
  public IVGSortedRelationAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedRelationAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedRelationAsDilTable <Element, Key> Self;

#define IVSortedRelationAsDilTableTypedef(Element, Key)\
  typedef  IVSortedRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedRelationAsDilTable
                            (INumber = 100);

















protected:

           IVSortedRelationAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isrdil.inl>


#pragma info (restore)


#endif // _ISRDIL_
