// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 36 1.5.1.4 source/core/collect/isr.h, collection, ioc.v400, 980918 
#ifndef _ISR_
#define _ISR_

#include <ilanglvl.hpp>
#include <iasr.h>
#include <iicsr.h>

#include <iivsr.h>

#include <iisrlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedRelation;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedRelationCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedRelation
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedRelationCursor
                            (IGSortedRelation
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationCursor <Element, Key, ElementOps>&
           operator=        (IGSortedRelationCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedRelationCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedRelation :
  public IASortedRelation <Element, Key> {
protected:

  typedef  IGSortedRelation <Element, Key, ElementOps> Self;

  typedef  ISortedRelationAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedRelationTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedRelationTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedRelationCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedRelation
                            (INumber = 100);

           IGSortedRelation
                            (IGSortedRelation
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelation <Element, Key, ElementOps>&
           operator=        (IGSortedRelation
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedRelation
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedRelation
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedRelationCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedRelation :
  public IGSortedRelation
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedRelation
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedRelation <Element, Key> Self;

#define ISortedRelationTypedef(Element, Key)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedRelation
                            (INumber = 100);

















protected:

           ISortedRelation
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedRelation :
  public IGSortedRelation
          <Element, Key, ElementOps > {

  typedef  IVGSortedRelation
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedRelation
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedRelationImpl
            <IVSortedRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedRelationTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedRelationTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedRelation
                            (INumber = 100);

















protected:

           IVGSortedRelation
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedRelation :
  public IVGSortedRelation
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedRelation
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedRelation <Element, Key> Self;

#define IVSortedRelationTypedef(Element, Key)\
  typedef  IVSortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedRelation
                            (INumber = 100);

















protected:

           IVSortedRelation
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isr.inl>


#pragma info (restore)


#endif // _ISR_
