// Revision: 74 1.9 source/ui/basectl/isplitcv.hpp, canvas, ioc.v400, 980918  
#ifndef _ISPLITCV_
  #define _ISPLITCV_
/*******************************************************************************
* FILE NAME: isplitcv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISplitCanvas                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <icolor.hpp>
#include <inotify.hpp>
#include <ipoint.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISplitBarSet;
class ISplitCanvasData;
class ISplitCanvasHandler;
class ISplitCanvasHandlerData;
class ISplitPercentage;
class ISplitPercentageSet;

#pragma enum(4)
#pragma pack(push,4)

class ISplitCanvas : public ICanvas {
typedef ICanvas
  Inherited;
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  ISplitCanvas ( unsigned long     windowIdentifier,
                 IWindow*          parent,
                 IWindow*          owner,
                 const IRectangle& initialSize = IRectangle(),
                 const Style&      style = defaultStyle() );

virtual
 ~ISplitCanvas ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, ISplitCanvas, ICanvas, IWindow);
static const Style
  IC_IMPORTU horizontal,
  IC_IMPORTU vertical,
  IC_IMPORTU noSplitBars,
  IC_IMPORTU classDefaultStyle;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*------------------------------- Orientation --------------------------------*/
enum Orientation  {
  horizontalSplit,
  verticalSplit
  };

Orientation
  orientation     ( ) const;

virtual ISplitCanvas
 &setOrientation  ( Orientation value );

/*--------------------------- Split Bar Thickness ----------------------------*/
enum SplitBarArea {
  splitBarEdge,
  splitBarMiddle
  };

virtual ISplitCanvas
 &setSplitBarThickness ( SplitBarArea  area,
                         unsigned long thickness );

unsigned long
  splitBarThickness    ( SplitBarArea  area );

/*--------------------------- Child Window Sizing ----------------------------*/
virtual ISplitCanvas
 &setSplitWindowPercentage ( IWindow*      window,
                             unsigned long percentage );

unsigned long
  splitWindowPercentage    ( IWindow* window );

/*---------------------------------- Layout Support --------------------------*/
virtual ISplitCanvas
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

/*---------------------------- Notification Members --------------------------*/
static INotificationId const
  IC_IMPORTU orientationId;

/*---------------------------------- Colors ----------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IColor
  splitBarEdgeColor        ( ) const;
#endif
virtual IColor
  splitBarMiddleColor      ( ) const;

#ifndef IC_MOTIF_FLAGNOP
virtual ISplitCanvas
 &setSplitBarEdgeColor     ( const IColor &color );
#endif
virtual ISplitCanvas
 &setSplitBarMiddleColor   ( const IColor &color );

#ifndef IC_MOTIF_FLAGNOP
virtual ISplitCanvas
 &resetSplitBarEdgeColor   ( ),
 &resetSplitBarMiddleColor ( );
#endif

protected:
/*---------------------------------- Layout Support --------------------------*/
virtual ISplitCanvas
 &layout ( );

private:
/*--------------------------------- Private ----------------------------------*/

/*----------------------------- Hidden Members -------------------------------*/
  ISplitCanvas ( const ISplitCanvas& canvas );
ISplitCanvas
 &operator=    ( const ISplitCanvas& canvas );

static Style
  currentDefaultStyle;

Style
  fCurrentStyle;

void
  resolveRatios ( );
ISplitCanvas
 &setResolvedPercentage ( IWindow*      window,
                          unsigned long percentage );
unsigned long
  resolvedPercentage    ( IWindow* window );

bool
#ifdef IC_MOTIF
  bClVertical,
  bClNoSplitBars,
#endif // IC_MOTIF
  bClRatiosNotResolved;

unsigned long
  ulClMiddleThickness,
  ulClEdgeThickness,
  ulClChildCount;

IColor
  clrClMiddleColor,
  clrClEdgeColor;

ISize
  sizClCanvasSize;

ISplitPercentageSet
 *pClSplitPercentageSet;

ISplitCanvasHandler
 *pClSplitCanvasHandler;

ISplitBarSet
 *pClSplitBarSet;

ISplitCanvasData
 *fSplitCanvasData;

friend class ISplitCanvasHandler;
#ifdef IC_MOTIF
friend class ISplitCanvasHandlerData;
#endif

friend bool
  ISplitPercentageDeleter ( ISplitPercentage* const& splitPercentageObj,
                            void*                    anything );
}; // ISplitCanvas

INESTEDBITFLAGCLASSFUNCS(Style, ISplitCanvas)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ISPLITCV_ */
