// Revision: 68 1.5.1.3 source/ui/basectl/ispintxt.hpp, listctls, ioc.v400, 980918 
#ifndef _ISPINTXT_
  #define _ISPINTXT_
/*******************************************************************************
* FILE NAME: ispintxt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITextSpinButton                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <ispinbas.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class ITextSpinButtonData;
class ITextSpinButtonCursorData;
class IResourceId;

#pragma enum(4)
#pragma pack(push,4)

class ITextSpinButton : public IBaseSpinButton {
typedef IBaseSpinButton
  Inherited;

public :
class Style;
class Cursor;
/*------------------------------- Constructors -------------------------------*/
   ITextSpinButton ( unsigned long     id,
                     IWindow*          parent,
                     IWindow*          owner,
                     const IRectangle& initial = IRectangle(),
                     const Style&      style   = defaultStyle() );

#ifdef IC_PMWIN
   ITextSpinButton ( unsigned long id,
                     IWindow*      parent );

   ITextSpinButton ( const IWindowHandle& handle );
#endif

virtual
  ~ITextSpinButton ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, ITextSpinButton, IBaseSpinButton,
                        IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

  virtual unsigned long
    convertToGUIStyle ( const IBitFlag& style,
                        bool         extendedOnly = false ) const;

/*------------------------- Set Text and Validate ----------------------------*/
virtual ITextSpinButton
  &setText ( const char*        string ),
  &setText ( const IResourceId& item );

virtual IString
  text ( ) const;

virtual bool
  isSpinFieldValid ( bool caseSensitive = false) const;

/*-------------------------- Text-List Operations ----------------------------*/
virtual IString
  elementAt ( unsigned long index ) const,
  elementAt ( const Cursor& cursor ) const;

virtual ITextSpinButton
  &replaceAt  ( const char*        newString,
                Cursor&            cursor ),
  &replaceAt  ( const IResourceId& item,
                Cursor&            cursor ),
  &removeAt   ( Cursor&            cursor ),
  &removeAll  ( ),
  &add        ( const char*         string,
                Cursor&             cursor ),
  &add        ( const IResourceId&  item,
                Cursor&             cursor ),
  &add        ( const char*         string,
                unsigned long       index  ),
  &add        ( const IResourceId&  item,
                unsigned long       index  ),
  &add        ( const char* const * stringArray,
                unsigned long       index,
                unsigned long       count ),
  &addAsNext  ( const char*         string,
                Cursor&             cursor ),
  &addAsNext  ( const IResourceId&  item,
                Cursor&             cursor ),
  &addAsFirst ( const char*         string ),
  &addAsFirst ( const IResourceId&  item   ),
  &addAsLast  ( const char*         string ),
  &addAsLast  ( const IResourceId&  item   ),
  &spinTo     ( unsigned long       index  ),
  &spinTo     ( const Cursor&       cursor ),
  &spinTo     ( const char*         string,
                bool             caseSensitive = false );

#ifdef IC_MOTIF
/*----------------------------- Limit and Spin -------------------------------*/
virtual ITextSpinButton
  &setLimit  ( unsigned long          aNumber ),
  &spinDown  ( unsigned long          spinBy = 1 ),
  &spinUp    ( unsigned long          spinBy = 1 );
#endif

/*----------------------- Observer Notification ------------------------------*/
virtual ITextSpinButton
 &enableNotification ( bool enable=true );

/*------------------------------ Nested Classes ------------------------------*/
class Cursor  {

public:
/*---------------------------- Constructors -----------------------------*/
  Cursor  ( const ITextSpinButton& spinButton );

virtual
  ~Cursor ( );

/*--------------------------- Cursor Movement ---------------------------*/
virtual bool
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( );

/*-------------------------- Cursor Validation --------------------------*/
virtual bool
  isValid    ( ) const;
virtual void
  invalidate ( );


private:
/*--------------------------- Hidden Members ----------------------------*/
  Cursor    ( const Cursor& cursor );
Cursor
  &operator= ( const Cursor& cursor );

/*--------------------------------- Private ----------------------------------*/
friend class ITextSpinButton;

ITextSpinButtonCursorData
 *fCursorData;
}; // ITextSpinButton::Cursor


private:
/*------------------------------ Hidden Members ------------------------------*/
ITextSpinButton ( const ITextSpinButton& spinButton );
ITextSpinButton
 &operator=     ( const ITextSpinButton& spinButton );

/*--------------------------------- Private ----------------------------------*/
friend class ITextSpinButton::Cursor;
friend class ITextSpinButtonCursorData;

unsigned
  findStringIndex(const Cursor& cursor) const,
  findStringIndex( unsigned long index ) const;
#ifdef IC_PMWIN
ITextSpinButton&
  refreshText ( );
#endif

static Style
  currentDefaultStyle;

ITextSpinButtonData
 *fTextSpinButtonData;
}; // ITextSpinButton

INESTEDBITFLAGCLASSFUNCS( Style, ITextSpinButton)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ispintxt.inl>

#endif // _ISPINTXT_
