// Revision: 63 1.6.1.3 source/ui/basectl/ispinnum.hpp, listctls, ioc.v400, 980918 
#ifndef _ISPINNUM_
  #define _ISPINNUM_
/*******************************************************************************
* FILE NAME: ispinnum.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     INumericSpinButton                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <ispinbas.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IRange;
class INumericSpinButtonData;

#pragma enum(4)
#pragma pack(push,4)

class INumericSpinButton : public IBaseSpinButton {
typedef IBaseSpinButton
  Inherited;

public :
class Style;
/*------------------------------- Constructors -------------------------------*/
  INumericSpinButton ( unsigned long     id,
                       IWindow*          parent,
                       IWindow*          owner,
                       const IRectangle& initial = IRectangle(),
                       const Style&      style   = defaultStyle() );

#ifdef IC_PMWIN
  INumericSpinButton ( unsigned long     id,
                       IWindow*          parent );

  INumericSpinButton ( const IWindowHandle& handle );
#endif

virtual
 ~INumericSpinButton ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, INumericSpinButton, IBaseSpinButton,
                        IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU padWithZeros;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

  virtual unsigned long
    convertToGUIStyle ( const IBitFlag& style,
                        bool         extendedOnly = false ) const;

/*------------------------- Number Range Operations --------------------------*/
virtual INumericSpinButton
 &setRange ( const IRange& aNewRange,
             bool       override = false ),
 &spinTo   ( long          aValue,
             bool       spinToClosest = false ),
 &setValue ( long aValue );

virtual IRange
  range ( ) const;

virtual long
  value ( ) const;

virtual bool
  isSpinFieldValid ( bool caseSensitive = false ) const;

#ifdef IC_MOTIF
/*----------------------------- Limit and Spin -------------------------------*/
virtual INumericSpinButton
  &setLimit  ( unsigned long          aNumber ),
  &spinDown  ( unsigned long          spinBy = 1 ),
  &spinUp    ( unsigned long          spinBy = 1 );
#endif

/*-------------------------- Observer Notification ---------------------------*/
virtual INumericSpinButton
 &enableNotification ( bool enable=true );

private:
/*------------------------------ Hidden Members ------------------------------*/
INumericSpinButton ( const INumericSpinButton& spinButton );
INumericSpinButton
 &operator=        ( const INumericSpinButton& spinButton );

/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;

INumericSpinButtonData
 *fNumericSpinButtonData;

};  // INumericSpinButton

INESTEDBITFLAGCLASSFUNCS( Style, INumericSpinButton)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ispinnum.inl>

#endif // _ISPINNUM_
