// Revision: 59 1.8.1.4 source/ui/basectl/ispinbas.hpp, listctls, ioc.v400, 980918 
#ifndef _ISPINBAS_
  #define _ISPINBAS_
/*******************************************************************************
* FILE NAME: ispinbas.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBaseSpinButton                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <icontrol.hpp>
#include <irect.hpp>
#include <ihandle.hpp>

#ifdef IC_MOTIF
  #include <X11/Xlib.h>
  #include <X11/IntrinsicP.h>     // for CoreP.h
  #include <X11/CoreP.h>          // for core.being_destroyed
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IBaseSpinButtonData;

#pragma enum(4)
#pragma pack(push,4)

class IBaseSpinButton : public IControl {
typedef IControl
  Inherited;

public :

/*----------------------------- Constructors ---------------------------------*/
virtual
  ~IBaseSpinButton ( );

/*----------------------------- Styles ---------------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IBaseSpinButton, IWindow, IControl);

static const Style
  IC_IMPORTU master,
  IC_IMPORTU servant,
  IC_IMPORTU readOnly,
  IC_IMPORTU noBorder,
  IC_IMPORTU pmCompatible,
  IC_IMPORTU fastSpin;
#ifndef IC_MOTIFPM_FLAGNOP
static const Style
  IC_IMPORTU border3D;
#endif
#ifndef IC_MOTIF_FLAGNOP
static const Style
  IC_IMPORTU leftAlign,
  IC_IMPORTU centerAlign,
  IC_IMPORTU rightAlign;
#endif

  virtual unsigned long
    convertToGUIStyle ( const IBitFlag& style,
                        bool         extendedOnly = false ) const;

/*---------------------------- Style Functions -------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
enum Alignment {
  left,
  right,
  center
};
#endif

virtual IBaseSpinButton
  &enableDataUpdate  ( bool   writeable = true ),
  &disableDataUpdate ( ),
  &enableFastSpin    ( bool   fast      = true ),
  &disableFastSpin   ( ),
  &addBorder         ( bool   add       = true ),
  &removeBorder      ( );
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IBaseSpinButton
  &setAlignment      ( Alignment alignment = left );
#endif

bool
  isMaster          ( ) const,
  isServant         ( ) const,
  isWriteable       ( ) const,
  isFastSpinEnabled ( ) const,
  isPMCompatible    ( ) const,
  hasBorder         ( ) const;

#ifndef IC_MOTIF_FLAGNOP
Alignment
  alignment  ( ) const;
#endif

/*----------------------------- Limit and Spin -------------------------------*/
unsigned long
  limit ( ) const;

virtual IBaseSpinButton
  &setLimit  ( unsigned long    aNumber = 255 ),
  &setMaster ( IBaseSpinButton& master        );


#ifndef IC_MOTIF_FLAGNOP
virtual IBaseSpinButton
  &spinDown  ( unsigned long    spinBy  = 1 ),
  &spinUp    ( unsigned long    spinBy  = 1 );
#endif

virtual bool
  isSpinFieldValid ( bool caseSensitive ) const = 0;

/*--------------------------------- Overrides --------------------------------*/
#ifdef IC_PMWIN
virtual IBaseSpinButton
 &enable ( bool enable = true );
#endif

#ifdef IC_PMWIN
virtual IColor
  foregroundColor () const;
#endif // IC_PMWIN

#ifdef IC_WIN
virtual IColor
  backgroundColor () const;

virtual IBaseSpinButton
 &setForegroundColor ( const IColor& color ),
 &setBackgroundColor ( const IColor& color ),
 &resetForegroundColor ( ),
 &resetBackgroundColor ( );
#endif //IC_WIN

/*------------------------- Attributes ---------------------------------------*/
#ifdef  IC_WIN
virtual bool
  hasFocus            ( ) const;
#endif

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU valueId,
  IC_IMPORTU textId;

#ifdef IC_PM
/*------------------------- Layout Support -----------------------------------*/
virtual IRectangle
  visibleRectangle     ( ) const;
#endif

protected:
/*------------------------------ Implementation ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

void
  initialize ( unsigned long        windowId,
               const IWindowHandle& parent,
               const IWindowHandle& owner,
               unsigned long        style,
               const IRectangle&    initial );
#ifdef IC_PMWIN
virtual void
  initialize ( );
#endif

/*---------------------------- Color Functions -------------------------------*/
#ifdef IC_WIN
virtual IBaseSpinButton
 &setColor         ( unsigned long colorArea,
                     const IColor& color );
#endif // IC_WIN
/*-------------------------- Protected Constructors --------------------------*/
  IBaseSpinButton ( );


private:
/*------------------------------- Hidden Members -----------------------------*/
  IBaseSpinButton ( const IBaseSpinButton& spinButton );
IBaseSpinButton
 &operator=       ( const IBaseSpinButton& spinButton );

/*--------------------------------- Private ----------------------------------*/
friend class IBaseSpinDefaultHandler;

#ifdef IC_MOTIF

friend void _System ibsbArmCallback (Widget w,
                                     XtPointer client_data,
                                     XtPointer call_data);
friend void _System ibsbDisarmCallback (Widget w,
                                        XtPointer client_data,
                                        XtPointer call_data);
#endif

IBaseSpinButtonData
 *fBaseSpinButtonData;
};  // IBaseSpinButton

INESTEDBITFLAGCLASSFUNCS( Style, IBaseSpinButton)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ISPINBAS_
