// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 34 1.5.1.4 source/core/collect/ismtab.h, collection, ioc.v400, 980918 
#ifndef _ISMTAB_
#define _ISMTAB_

#include <ilanglvl.hpp>
#include <iasm.h>
#include <iicsm.h>

#include <iivsm.h>

#include <iismtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedMapAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedMapAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsTableCursor
                            (IGSortedMapAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedMapAsTable :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsTable <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedMapAsTableCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedMapAsTable
                            (INumber = 100);

           IGSortedMapAsTable
                            (IGSortedMapAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsTable <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedMapAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedMapAsTable :
  public IGSortedMapAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedMapAsTable <Element, Key> Self;

#define ISortedMapAsTableTypedef(Element, Key)\
  typedef  ISortedMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedMapAsTable
                            (INumber = 100);

















protected:

           ISortedMapAsTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedMapAsTable :
  public IGSortedMapAsTable
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedMapAsTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedMapAsTable
                            (INumber = 100);

















protected:

           IVGSortedMapAsTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedMapAsTable :
  public IVGSortedMapAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedMapAsTable <Element, Key> Self;

#define IVSortedMapAsTableTypedef(Element, Key)\
  typedef  IVSortedMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedMapAsTable
                            (INumber = 100);

















protected:

           IVSortedMapAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ismtab.inl>


#pragma info (restore)


#endif // _ISMTAB_
