// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 29 1.5.1.4 source/core/collect/ismlst.h, collection, ioc.v400, 980918 
#ifndef _ISMLST_
#define _ISMLST_

#include <ilanglvl.hpp>
#include <iasm.h>
#include <iicsm.h>

#include <iivsm.h>

#include <iismlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedMapAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedMapAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsListCursor
                            (IGSortedMapAsList
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsListCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedMapAsList :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsList <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsListTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedMapAsListCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedMapAsList
                            (INumber = 100);

           IGSortedMapAsList
                            (IGSortedMapAsList
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsList <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsList
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedMapAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsListCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedMapAsList :
  public IGSortedMapAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedMapAsList <Element, Key> Self;

#define ISortedMapAsListTypedef(Element, Key)\
  typedef  ISortedMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedMapAsList
                            (INumber = 100);

















protected:

           ISortedMapAsList
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedMapAsList :
  public IGSortedMapAsList
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsList
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedMapAsList
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsListTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedMapAsList
                            (INumber = 100);

















protected:

           IVGSortedMapAsList
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedMapAsList :
  public IVGSortedMapAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedMapAsList <Element, Key> Self;

#define IVSortedMapAsListTypedef(Element, Key)\
  typedef  IVSortedMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedMapAsList
                            (INumber = 100);

















protected:

           IVSortedMapAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ismlst.inl>


#pragma info (restore)


#endif // _ISMLST_
