// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 27 1.5.1.4 source/core/collect/ismdil.h, collection, ioc.v400, 980918 
#ifndef _ISMDIL_
#define _ISMDIL_

#include <ilanglvl.hpp>
#include <iasm.h>
#include <iicsm.h>

#include <iivsm.h>

#include <iismdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedMapAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedMapAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsDilTableCursor
                            (IGSortedMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedMapAsDilTable :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsDilTable <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedMapAsDilTableCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedMapAsDilTable
                            (INumber = 100);

           IGSortedMapAsDilTable
                            (IGSortedMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsDilTable <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedMapAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsDilTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedMapAsDilTable :
  public IGSortedMapAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedMapAsDilTable <Element, Key> Self;

#define ISortedMapAsDilTableTypedef(Element, Key)\
  typedef  ISortedMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedMapAsDilTable
                            (INumber = 100);

















protected:

           ISortedMapAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedMapAsDilTable :
  public IGSortedMapAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedMapAsDilTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedMapAsDilTable
                            (INumber = 100);

















protected:

           IVGSortedMapAsDilTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedMapAsDilTable :
  public IVGSortedMapAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedMapAsDilTable <Element, Key> Self;

#define IVSortedMapAsDilTableTypedef(Element, Key)\
  typedef  IVSortedMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedMapAsDilTable
                            (INumber = 100);

















protected:

           IVSortedMapAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ismdil.inl>


#pragma info (restore)


#endif // _ISMDIL_
