// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 25 1.5.1.4 source/core/collect/ismbst.h, collection, ioc.v400, 980918 
#ifndef _ISMBST_
#define _ISMBST_

#include <ilanglvl.hpp>
#include <iasm.h>
#include <iicsm.h>

#include <iivsm.h>

#include <iismbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedMapAsBstTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsBstTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedMapAsBstTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsBstTreeCursor
                            (IGSortedMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsBstTreeCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsBstTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsBstTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedMapAsBstTree :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsBstTree <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedMapAsBstTreeCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedMapAsBstTree
                            (INumber = 100);

           IGSortedMapAsBstTree
                            (IGSortedMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsBstTree <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedMapAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsBstTreeCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedMapAsBstTree :
  public IGSortedMapAsBstTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsBstTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedMapAsBstTree <Element, Key> Self;

#define ISortedMapAsBstTreeTypedef(Element, Key)\
  typedef  ISortedMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedMapAsBstTree
                            (INumber = 100);

















protected:

           ISortedMapAsBstTree
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedMapAsBstTree :
  public IGSortedMapAsBstTree
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsBstTree
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedMapAsBstTree
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedMapAsBstTree
                            (INumber = 100);

















protected:

           IVGSortedMapAsBstTree
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedMapAsBstTree :
  public IVGSortedMapAsBstTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsBstTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedMapAsBstTree <Element, Key> Self;

#define IVSortedMapAsBstTreeTypedef(Element, Key)\
  typedef  IVSortedMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedMapAsBstTree
                            (INumber = 100);

















protected:

           IVSortedMapAsBstTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ismbst.inl>


#pragma info (restore)


#endif // _ISMBST_
