// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 23 1.5.1.4 source/core/collect/ismavl.h, collection, ioc.v400, 980918 
#ifndef _ISMAVL_
#define _ISMAVL_

#include <ilanglvl.hpp>
#include <iasm.h>
#include <iicsm.h>

#include <iivsm.h>

#include <iismavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedMapAsAvlTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsAvlTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedMapAsAvlTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsAvlTreeCursor
                            (IGSortedMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsAvlTreeCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsAvlTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsAvlTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedMapAsAvlTree :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsAvlTree <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedMapAsAvlTreeCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedMapAsAvlTree
                            (INumber = 100);

           IGSortedMapAsAvlTree
                            (IGSortedMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsAvlTree <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedMapAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsAvlTreeCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedMapAsAvlTree :
  public IGSortedMapAsAvlTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsAvlTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedMapAsAvlTree <Element, Key> Self;

#define ISortedMapAsAvlTreeTypedef(Element, Key)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedMapAsAvlTree
                            (INumber = 100);

















protected:

           ISortedMapAsAvlTree
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedMapAsAvlTree :
  public IGSortedMapAsAvlTree
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsAvlTree
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedMapAsAvlTree
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedMapAsAvlTree
                            (INumber = 100);

















protected:

           IVGSortedMapAsAvlTree
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedMapAsAvlTree :
  public IVGSortedMapAsAvlTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsAvlTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedMapAsAvlTree <Element, Key> Self;

#define IVSortedMapAsAvlTreeTypedef(Element, Key)\
  typedef  IVSortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedMapAsAvlTree
                            (INumber = 100);

















protected:

           IVSortedMapAsAvlTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ismavl.inl>


#pragma info (restore)


#endif // _ISMAVL_
