#ifndef _ISM2_
  #define _ISM2_
/*******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>

#ifdef IC_USE_STL
  #include <ikeyset2.h>

  template <class Element, class Key, class Imp>
    class ITImpSortedMap : public ITImpKeySet<Element, Key, Imp>
  {
  public:
    ITImpSortedMap( unsigned long numberOfElements = 100);
    ~ITImpSortedMap();
  };

  template <class Element, class Key>
    class ISortedMap : public ITImpSortedMap<Element, Key, Element>
  {
    public:
    ISortedMap( unsigned long numberOfElements = 100);
   ~ISortedMap();
  };


  #ifdef IC_USE_STL_VPTR
    template <class Element, class Key>
      class IVPtrSortedMap : public ITImpSortedMap<Element, Key, void*>
    {
      public:
      IVPtrSortedMap( unsigned long numberOfElements = 100);
     ~IVPtrSortedMap();
    };
  #else
    #define IVPtrSortedMap ISortedMap
  #endif

  #ifndef __TEMPINC__
    #include <ism2.c>
  #endif

#else
  #include <ism.h>
  #define IVPtrSortedMap ISortedMap
#endif

#endif // _ISM2_

