// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 21 1.5.1.4 source/core/collect/ism.h, collection, ioc.v400, 980918 
#ifndef _ISM_
#define _ISM_

#include <ilanglvl.hpp>
#include <iasm.h>
#include <iicsm.h>

#include <iivsm.h>

#include <iismavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGSortedMap;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGSortedMapCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedMap
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapCursor
                            (IGSortedMap
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGSortedMap :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMap <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedMapCursor
            <Element, Key, ElementOps> Cursor;




           IGSortedMap
                            (INumber = 100);

           IGSortedMap
                            (IGSortedMap
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMap <Element, Key, ElementOps>&
           operator=        (IGSortedMap
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGSortedMap
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMap
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class ISortedMap :
  public IGSortedMap
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMap
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedMap <Element, Key> Self;

#define ISortedMapTypedef(Element, Key)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedMap
                            (INumber = 100);

















protected:

           ISortedMap
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGSortedMap :
  public IGSortedMap
          <Element, Key, ElementOps > {

  typedef  IVGSortedMap
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedMap
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedMap
                            (INumber = 100);

















protected:

           IVGSortedMap
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVSortedMap :
  public IVGSortedMap
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMap
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedMap <Element, Key> Self;

#define IVSortedMapTypedef(Element, Key)\
  typedef  IVSortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedMap
                            (INumber = 100);

















protected:

           IVSortedMap
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ism.inl>


#pragma info (restore)


#endif // _ISM_
