// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 19 1.5.1.4 source/core/collect/isettab.h, collection, ioc.v400, 980918 
#ifndef _ISETTAB_
#define _ISETTAB_

#include <ilanglvl.hpp>
#include <iaset.h>
#include <iicset.h>

#include <iivset.h>

#include <iisettab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSetAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSetAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGSetAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsTableCursor
                            (IGSetAsTable
                              <
                               Element, ElementOps> const&);

  IGSetAsTableCursor <Element, ElementOps>&
           operator=        (IGSetAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSetAsTable :
  public IASet <Element> {
protected:

  typedef  IGSetAsTable <Element, ElementOps> Self;

  typedef  ISetAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsTableTypedef(Element, ElementOps)\
  typedef  ISetAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSetAsTableCursor
            <Element, ElementOps> Cursor;




           IGSetAsTable
                            (INumber = 100);

           IGSetAsTable
                            (IGSetAsTable
                              <
                               Element, ElementOps> const&);

  IGSetAsTable <Element, ElementOps>&
           operator=        (IGSetAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGSetAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class ISetAsTable :
  public IGSetAsTable
          <Element, ICOps <Element> > {

  typedef  IGSetAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISetAsTable <Element> Self;

#define ISetAsTableTypedef(Element)\
  typedef  ISetAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISetAsTable
                            (INumber = 100);

















protected:

           ISetAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSetAsTable :
  public IGSetAsTable
          <Element, ElementOps > {

  typedef  IVGSetAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSetAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsTableTypedef(Element, ElementOps)\
  typedef  ISetAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSetAsTable
                            (INumber = 100);

















protected:

           IVGSetAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVSetAsTable :
  public IVGSetAsTable
          <Element, ICOps <Element> > {

  typedef  IVGSetAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSetAsTable <Element> Self;

#define IVSetAsTableTypedef(Element)\
  typedef  IVSetAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSetAsTable
                            (INumber = 100);

















protected:

           IVSetAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isettab.inl>


#pragma info (restore)


#endif // _ISETTAB_
