// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 14 1.5.1.4 source/core/collect/isetlst.h, collection, ioc.v400, 980918 
#ifndef _ISETLST_
#define _ISETLST_

#include <ilanglvl.hpp>
#include <iaset.h>
#include <iicset.h>

#include <iivset.h>

#include <iisetlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSetAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSetAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGSetAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsListCursor
                            (IGSetAsList
                              <
                               Element, ElementOps> const&);

  IGSetAsListCursor <Element, ElementOps>&
           operator=        (IGSetAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSetAsList :
  public IASet <Element> {
protected:

  typedef  IGSetAsList <Element, ElementOps> Self;

  typedef  ISetAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsListTypedef(Element, ElementOps)\
  typedef  ISetAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSetAsListCursor
            <Element, ElementOps> Cursor;




           IGSetAsList
                            (INumber = 100);

           IGSetAsList
                            (IGSetAsList
                              <
                               Element, ElementOps> const&);

  IGSetAsList <Element, ElementOps>&
           operator=        (IGSetAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGSetAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsListCursor <Element, ElementOps>;






















};

template <class Element>
class ISetAsList :
  public IGSetAsList
          <Element, ICOps <Element> > {

  typedef  IGSetAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISetAsList <Element> Self;

#define ISetAsListTypedef(Element)\
  typedef  ISetAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISetAsList
                            (INumber = 100);

















protected:

           ISetAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSetAsList :
  public IGSetAsList
          <Element, ElementOps > {

  typedef  IVGSetAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSetAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsListTypedef(Element, ElementOps)\
  typedef  ISetAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSetAsList
                            (INumber = 100);

















protected:

           IVGSetAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVSetAsList :
  public IVGSetAsList
          <Element, ICOps <Element> > {

  typedef  IVGSetAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSetAsList <Element> Self;

#define IVSetAsListTypedef(Element)\
  typedef  IVSetAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSetAsList
                            (INumber = 100);

















protected:

           IVSetAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isetlst.inl>


#pragma info (restore)


#endif // _ISETLST_
