// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 12 1.5.1.4 source/core/collect/isethsh.h, collection, ioc.v400, 980918 
#ifndef _ISETHSH_
#define _ISETHSH_

#include <ilanglvl.hpp>
#include <iaset.h>
#include <iicset.h>

#include <iivset.h>

#include <iisethsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSetAsHshTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSetAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGSetAsHshTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsHshTableCursor
                            (IGSetAsHshTable
                              <
                               Element, ElementOps> const&);

  IGSetAsHshTableCursor <Element, ElementOps>&
           operator=        (IGSetAsHshTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsHshTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSetAsHshTable :
  public IASet <Element> {
protected:

  typedef  IGSetAsHshTable <Element, ElementOps> Self;

  typedef  ISetAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsHshTableTypedef(Element, ElementOps)\
  typedef  ISetAsHshTableOps\
            <Element,\
             IWEHOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsHshTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSetAsHshTableCursor
            <Element, ElementOps> Cursor;




           IGSetAsHshTable
                            (INumber = 100);

           IGSetAsHshTable
                            (IGSetAsHshTable
                              <
                               Element, ElementOps> const&);

  IGSetAsHshTable <Element, ElementOps>&
           operator=        (IGSetAsHshTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGSetAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsHshTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsHshTableCursor <Element, ElementOps>;






















};

template <class Element>
class ISetAsHshTable :
  public IGSetAsHshTable
          <Element, IEHOps <Element> > {

  typedef  IGSetAsHshTable
            <Element,
             IEHOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISetAsHshTable <Element> Self;

#define ISetAsHshTableTypedef(Element)\
  typedef  ISetAsHshTableOps\
            <Element,\
             IWEHOps <Element, IEHOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISetAsHshTable
                            (INumber = 100);

















protected:

           ISetAsHshTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSetAsHshTable :
  public IGSetAsHshTable
          <Element, ElementOps > {

  typedef  IVGSetAsHshTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSetAsHshTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsHshTableTypedef(Element, ElementOps)\
  typedef  ISetAsHshTableOps\
            <Element,\
             IWEHOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsHshTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSetAsHshTable
                            (INumber = 100);

















protected:

           IVGSetAsHshTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVSetAsHshTable :
  public IVGSetAsHshTable
          <Element, IEHOps <Element> > {

  typedef  IVGSetAsHshTable
            <Element,
             IEHOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSetAsHshTable <Element> Self;

#define IVSetAsHshTableTypedef(Element)\
  typedef  IVSetAsHshTableOps\
            <Element,\
             IWEHOps <Element, IEHOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSetAsHshTable
                            (INumber = 100);

















protected:

           IVSetAsHshTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isethsh.inl>


#pragma info (restore)


#endif // _ISETHSH_
