// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 09 1.5.1.4 source/core/collect/isetdil.h, collection, ioc.v400, 980918 
#ifndef _ISETDIL_
#define _ISETDIL_

#include <ilanglvl.hpp>
#include <iaset.h>
#include <iicset.h>

#include <iivset.h>

#include <iisetdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSetAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSetAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGSetAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsDilTableCursor
                            (IGSetAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSetAsDilTableCursor <Element, ElementOps>&
           operator=        (IGSetAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSetAsDilTable :
  public IASet <Element> {
protected:

  typedef  IGSetAsDilTable <Element, ElementOps> Self;

  typedef  ISetAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsDilTableTypedef(Element, ElementOps)\
  typedef  ISetAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSetAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGSetAsDilTable
                            (INumber = 100);

           IGSetAsDilTable
                            (IGSetAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSetAsDilTable <Element, ElementOps>&
           operator=        (IGSetAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGSetAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class ISetAsDilTable :
  public IGSetAsDilTable
          <Element, ICOps <Element> > {

  typedef  IGSetAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISetAsDilTable <Element> Self;

#define ISetAsDilTableTypedef(Element)\
  typedef  ISetAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISetAsDilTable
                            (INumber = 100);

















protected:

           ISetAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSetAsDilTable :
  public IGSetAsDilTable
          <Element, ElementOps > {

  typedef  IVGSetAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSetAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsDilTableTypedef(Element, ElementOps)\
  typedef  ISetAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSetAsDilTable
                            (INumber = 100);

















protected:

           IVGSetAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVSetAsDilTable :
  public IVGSetAsDilTable
          <Element, ICOps <Element> > {

  typedef  IVGSetAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSetAsDilTable <Element> Self;

#define IVSetAsDilTableTypedef(Element)\
  typedef  IVSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSetAsDilTable
                            (INumber = 100);

















protected:

           IVSetAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isetdil.inl>


#pragma info (restore)


#endif // _ISETDIL_
