// Revision: 38 1.3.1.6 source/ui/basectl/isetbut.hpp, buttonctls, ioc.v400, 980918 
#ifndef _ISETBUT_
  #define _ISETBUT_
/*******************************************************************************
* FILE NAME: isetbut.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISetttingButtton                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibutton.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISettingButtonData;

#pragma enum(4)
#pragma pack(push,4)

class ISettingButton : public IButton  {
typedef IButton
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISettingButton ( );
virtual
 ~ISettingButton ( );

/*-------------------------------- Selection ---------------------------------*/
bool
  isSelected     ( ) const;
virtual ISettingButton
 &select         ( bool select = true ),
 &deselect       ( );

/*------------------------------- Auto Select --------------------------------*/
virtual ISettingButton&
  enableAutoSelect  ( bool enable ) = 0;
virtual ISettingButton&
  disableAutoSelect ( )             = 0;
virtual bool
  isAutoSelect      ( ) const       = 0;

/*--------------------- Notification Event Descriptions ----------------------*/
static INotificationId const
  IC_IMPORTU selectId;

/*-------------------------- Observer Notification ---------------------------*/
virtual ISettingButton
 &enableNotification ( bool enable = true );

protected:
/*---------------------- Event Handling Implementation -----------------------*/
#ifdef IC_MOTIF
virtual bool
  passEventToOwner       ( IEvent &event );
#endif  //IC_MOTIF

#ifdef IC_WIN
/*---------------------- Bidirectional Language Support ----------------------*/
virtual ISettingButton
 &setBidiSettings ( const IBidiSettings& bidiSettings,
                    bool                 childInherit,
                    bool                 refresh );
#endif

private:
/*--------------------------------- Private ----------------------------------*/
ISettingButtonData
 *fSettingButtonData;

/*----------------------------- Hidden Functions -----------------------------*/
  ISettingButton     ( const ISettingButton& );
ISettingButton
 &operator=          ( const ISettingButton& );
};  // class ISettingButton

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _ISETBUT_ */
