// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 07 1.5.1.4 source/core/collect/isetbst.h, collection, ioc.v400, 980918 
#ifndef _ISETBST_
#define _ISETBST_

#include <ilanglvl.hpp>
#include <iaset.h>
#include <iicset.h>

#include <iivset.h>

#include <iisetbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSetAsBstTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSetAsBstTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGSetAsBstTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsBstTreeCursor
                            (IGSetAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSetAsBstTreeCursor <Element, ElementOps>&
           operator=        (IGSetAsBstTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsBstTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSetAsBstTree :
  public IASet <Element> {
protected:

  typedef  IGSetAsBstTree <Element, ElementOps> Self;

  typedef  ISetAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsBstTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSetAsBstTreeCursor
            <Element, ElementOps> Cursor;




           IGSetAsBstTree
                            (INumber = 100);

           IGSetAsBstTree
                            (IGSetAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSetAsBstTree <Element, ElementOps>&
           operator=        (IGSetAsBstTree
                              <
                               Element, ElementOps> const&);



















protected:

           IGSetAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsBstTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsBstTreeCursor <Element, ElementOps>;






















};

template <class Element>
class ISetAsBstTree :
  public IGSetAsBstTree
          <Element, ICOps <Element> > {

  typedef  IGSetAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISetAsBstTree <Element> Self;

#define ISetAsBstTreeTypedef(Element)\
  typedef  ISetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISetAsBstTree
                            (INumber = 100);

















protected:

           ISetAsBstTree
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSetAsBstTree :
  public IGSetAsBstTree
          <Element, ElementOps > {

  typedef  IVGSetAsBstTree
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSetAsBstTree
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsBstTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSetAsBstTree
                            (INumber = 100);

















protected:

           IVGSetAsBstTree
                              (PureImplementation&);

private:












};

template <class Element>
class IVSetAsBstTree :
  public IVGSetAsBstTree
          <Element, ICOps <Element> > {

  typedef  IVGSetAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSetAsBstTree <Element> Self;

#define IVSetAsBstTreeTypedef(Element)\
  typedef  IVSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSetAsBstTree
                            (INumber = 100);

















protected:

           IVSetAsBstTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isetbst.inl>


#pragma info (restore)


#endif // _ISETBST_
