// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 05 1.5.1.4 source/core/collect/isetavl.h, collection, ioc.v400, 980918 
#ifndef _ISETAVL_
#define _ISETAVL_

#include <ilanglvl.hpp>
#include <iaset.h>
#include <iicset.h>

#include <iivset.h>

#include <iisetavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSetAsAvlTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSetAsAvlTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGSetAsAvlTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsAvlTreeCursor
                            (IGSetAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSetAsAvlTreeCursor <Element, ElementOps>&
           operator=        (IGSetAsAvlTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsAvlTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSetAsAvlTree :
  public IASet <Element> {
protected:

  typedef  IGSetAsAvlTree <Element, ElementOps> Self;

  typedef  ISetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSetAsAvlTreeCursor
            <Element, ElementOps> Cursor;




           IGSetAsAvlTree
                            (INumber = 100);

           IGSetAsAvlTree
                            (IGSetAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSetAsAvlTree <Element, ElementOps>&
           operator=        (IGSetAsAvlTree
                              <
                               Element, ElementOps> const&);



















protected:

           IGSetAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsAvlTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsAvlTreeCursor <Element, ElementOps>;






















};

template <class Element>
class ISetAsAvlTree :
  public IGSetAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IGSetAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISetAsAvlTree <Element> Self;

#define ISetAsAvlTreeTypedef(Element)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISetAsAvlTree
                            (INumber = 100);

















protected:

           ISetAsAvlTree
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSetAsAvlTree :
  public IGSetAsAvlTree
          <Element, ElementOps > {

  typedef  IVGSetAsAvlTree
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSetAsAvlTree
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSetAsAvlTree
                            (INumber = 100);

















protected:

           IVGSetAsAvlTree
                              (PureImplementation&);

private:












};

template <class Element>
class IVSetAsAvlTree :
  public IVGSetAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IVGSetAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSetAsAvlTree <Element> Self;

#define IVSetAsAvlTreeTypedef(Element)\
  typedef  IVSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSetAsAvlTree
                            (INumber = 100);

















protected:

           IVSetAsAvlTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isetavl.inl>


#pragma info (restore)


#endif // _ISETAVL_
