// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 03 1.6.1.4 source/core/collect/iset.h, collection, ioc.v400, 980918 
#ifndef _ISET_
#define _ISET_

#include <ilanglvl.hpp>
#include <iaset.h>
#include <iicset.h>

#include <iivset.h>

#include <iisetavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSet;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSetCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGSet
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetCursor
                            (IGSet
                              <
                               Element, ElementOps> const&);

  IGSetCursor <Element, ElementOps>&
           operator=        (IGSetCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSet :
  public IASet <Element> {
protected:

  typedef  IGSet <Element, ElementOps> Self;

  typedef  ISetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetTypedef(Element, ElementOps)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSetCursor
            <Element, ElementOps> Cursor;




           IGSet
                            (INumber = 100);

           IGSet
                            (IGSet
                              <
                               Element, ElementOps> const&);

  IGSet <Element, ElementOps>&
           operator=        (IGSet
                              <
                               Element, ElementOps> const&);



















protected:

           IGSet
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSet
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetCursor <Element, ElementOps>;






















};

template <class Element>
class ISet :
  public IGSet
          <Element, ICOps <Element> > {

  typedef  IGSet
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISet <Element> Self;

#define ISetTypedef(Element)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISet
                            (INumber = 100);

















protected:

           ISet
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSet :
  public IGSet
          <Element, ElementOps > {

  typedef  IVGSet
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSet
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetTypedef(Element, ElementOps)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSet
                            (INumber = 100);

















protected:

           IVGSet
                              (PureImplementation&);

private:












};

template <class Element>
class IVSet :
  public IVGSet
          <Element, ICOps <Element> > {

  typedef  IVGSet
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSet <Element> Self;

#define IVSetTypedef(Element)\
  typedef  IVSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSet
                            (INumber = 100);

















protected:

           IVSet
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iset.inl>


#pragma info (restore)


#endif // _ISET_
