// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 01 1.5.1.4 source/core/collect/iseqtab.h, collection, ioc.v400, 980918 
#ifndef _ISEQTAB_
#define _ISEQTAB_

#include <ilanglvl.hpp>
#include <iaseq.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSequenceAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSequenceAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSequenceAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSequenceAsTableCursor
                            (IGSequenceAsTable
                              <
                               Element, ElementOps> const&);

  IGSequenceAsTableCursor <Element, ElementOps>&
           operator=        (IGSequenceAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSequenceAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSequenceAsTable :
  public IASequence <Element> {
protected:

  typedef  IGSequenceAsTable <Element, ElementOps> Self;

  typedef  ISequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGSequenceAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSequenceAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSequenceAsTableCursor
            <Element, ElementOps> Cursor;




           IGSequenceAsTable
                            (INumber = 100);

           IGSequenceAsTable
                            (IGSequenceAsTable
                              <
                               Element, ElementOps> const&);

  IGSequenceAsTable <Element, ElementOps>&
           operator=        (IGSequenceAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGSequenceAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSequenceAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSequenceAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class ISequenceAsTable :
  public IGSequenceAsTable
          <Element, IStdOps <Element> > {

  typedef  IGSequenceAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISequenceAsTable <Element> Self;

#define ISequenceAsTableTypedef(Element)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISequenceAsTable
                            (INumber = 100);

















protected:

           ISequenceAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSequenceAsTable :
  public IGSequenceAsTable
          <Element, ElementOps > {

  typedef  IVGSequenceAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSequenceAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSequenceAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSequenceAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSequenceAsTable
                            (INumber = 100);

















protected:

           IVGSequenceAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVSequenceAsTable :
  public IVGSequenceAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGSequenceAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSequenceAsTable <Element> Self;

#define IVSequenceAsTableTypedef(Element)\
  typedef  IVSequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSequenceAsTable
                            (INumber = 100);

















protected:

           IVSequenceAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iseqtab.inl>


#pragma info (restore)


#endif // _ISEQTAB_
