// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 99 1.5.1.4 source/core/collect/iseqlst.h, collection, ioc.v400, 980918 
#ifndef _ISEQLST_
#define _ISEQLST_

#include <ilanglvl.hpp>
#include <iaseq.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSequenceAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSequenceAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSequenceAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSequenceAsListCursor
                            (IGSequenceAsList
                              <
                               Element, ElementOps> const&);

  IGSequenceAsListCursor <Element, ElementOps>&
           operator=        (IGSequenceAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSequenceAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSequenceAsList :
  public IASequence <Element> {
protected:

  typedef  IGSequenceAsList <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGSequenceAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSequenceAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSequenceAsListCursor
            <Element, ElementOps> Cursor;




           IGSequenceAsList
                            (INumber = 100);

           IGSequenceAsList
                            (IGSequenceAsList
                              <
                               Element, ElementOps> const&);

  IGSequenceAsList <Element, ElementOps>&
           operator=        (IGSequenceAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGSequenceAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSequenceAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSequenceAsListCursor <Element, ElementOps>;






















};

template <class Element>
class ISequenceAsList :
  public IGSequenceAsList
          <Element, IStdOps <Element> > {

  typedef  IGSequenceAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISequenceAsList <Element> Self;

#define ISequenceAsListTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISequenceAsList
                            (INumber = 100);

















protected:

           ISequenceAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSequenceAsList :
  public IGSequenceAsList
          <Element, ElementOps > {

  typedef  IVGSequenceAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSequenceAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSequenceAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSequenceAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSequenceAsList
                            (INumber = 100);

















protected:

           IVGSequenceAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVSequenceAsList :
  public IVGSequenceAsList
          <Element, IStdOps <Element> > {

  typedef  IVGSequenceAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSequenceAsList <Element> Self;

#define IVSequenceAsListTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSequenceAsList
                            (INumber = 100);

















protected:

           IVSequenceAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iseqlst.inl>


#pragma info (restore)


#endif // _ISEQLST_
