// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 97 1.5.1.4 source/core/collect/iseqdil.h, collection, ioc.v400, 980918 
#ifndef _ISEQDIL_
#define _ISEQDIL_

#include <ilanglvl.hpp>
#include <iaseq.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSequenceAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSequenceAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSequenceAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSequenceAsDilTableCursor
                            (IGSequenceAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSequenceAsDilTableCursor <Element, ElementOps>&
           operator=        (IGSequenceAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSequenceAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSequenceAsDilTable :
  public IASequence <Element> {
protected:

  typedef  IGSequenceAsDilTable <Element, ElementOps> Self;

  typedef  ISequenceAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGSequenceAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSequenceAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSequenceAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGSequenceAsDilTable
                            (INumber = 100);

           IGSequenceAsDilTable
                            (IGSequenceAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSequenceAsDilTable <Element, ElementOps>&
           operator=        (IGSequenceAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGSequenceAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSequenceAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSequenceAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class ISequenceAsDilTable :
  public IGSequenceAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGSequenceAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISequenceAsDilTable <Element> Self;

#define ISequenceAsDilTableTypedef(Element)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISequenceAsDilTable
                            (INumber = 100);

















protected:

           ISequenceAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSequenceAsDilTable :
  public IGSequenceAsDilTable
          <Element, ElementOps > {

  typedef  IVGSequenceAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSequenceAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSequenceAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSequenceAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSequenceAsDilTable
                            (INumber = 100);

















protected:

           IVGSequenceAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVSequenceAsDilTable :
  public IVGSequenceAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGSequenceAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSequenceAsDilTable <Element> Self;

#define IVSequenceAsDilTableTypedef(Element)\
  typedef  IVSequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSequenceAsDilTable
                            (INumber = 100);

















protected:

           IVSequenceAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iseqdil.inl>


#pragma info (restore)


#endif // _ISEQDIL_
