// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 95 1.5.1.4 source/core/collect/iseq.h, collection, ioc.v400, 980918 
#ifndef _ISEQ_
#define _ISEQ_

#include <ilanglvl.hpp>
#include <iaseq.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSequence;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSequenceCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSequence
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSequenceCursor
                            (IGSequence
                              <
                               Element, ElementOps> const&);

  IGSequenceCursor <Element, ElementOps>&
           operator=        (IGSequenceCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSequenceCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSequence :
  public IASequence <Element> {
protected:

  typedef  IGSequence <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGSequenceTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSequenceTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSequenceCursor
            <Element, ElementOps> Cursor;




           IGSequence
                            (INumber = 100);

           IGSequence
                            (IGSequence
                              <
                               Element, ElementOps> const&);

  IGSequence <Element, ElementOps>&
           operator=        (IGSequence
                              <
                               Element, ElementOps> const&);



















protected:

           IGSequence
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSequence
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSequenceCursor <Element, ElementOps>;






















};

template <class Element>
class ISequence :
  public IGSequence
          <Element, IStdOps <Element> > {

  typedef  IGSequence
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISequence <Element> Self;

#define ISequenceTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISequence
                            (INumber = 100);

















protected:

           ISequence
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSequence :
  public IGSequence
          <Element, ElementOps > {

  typedef  IVGSequence
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSequence
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSequenceTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSequenceTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSequence
                            (INumber = 100);

















protected:

           IVGSequence
                              (PureImplementation&);

private:












};

template <class Element>
class IVSequence :
  public IVGSequence
          <Element, IStdOps <Element> > {

  typedef  IVGSequence
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSequence <Element> Self;

#define IVSequenceTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSequence
                            (INumber = 100);

















protected:

           IVSequence
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iseq.inl>


#pragma info (restore)


#endif // _ISEQ_
