// Revision: 33 1.13 source/ui/basectl/iscroll.hpp, slidectls, ioc.v400, 980918 
#ifndef _ISCROLL_
  #define _ISCROLL_
/*******************************************************************************
* FILE NAME: iscroll.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IScrollBar                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IRange;
class IWindowHandle;
class IScrollBarData;
class IColor;
class ISize;

#pragma enum(4)
#pragma pack(push,4)

class IScrollBar : public IControl {
typedef IControl
  Inherited;

public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IScrollBar ( unsigned long     id,
               IWindow*          parent,
               IWindow*          owner,
               const IRectangle& initial = IRectangle(),
               const Style&      style = defaultStyle() );

  IScrollBar ( unsigned long     id,
               IWindow*          parent,
               IWindow*          owner,
               const IRange&     scrollableItems,
               unsigned long     visibleItemCount,
               unsigned long     scrollBoxPosition = 1,
               const IRectangle& initial = IRectangle(),
               const Style&      style = defaultStyle() );

  IScrollBar ( unsigned long     id,
               IWindow*          parent );

  IScrollBar ( const IWindowHandle& handle );

virtual
 ~IScrollBar ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IScrollBar, IWindow, IControl);
static const Style
  IC_IMPORTU horizontal,
  IC_IMPORTU vertical,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*------------------------------ System Values -------------------------------*/
static unsigned long
  systemScrollBarWidth     ( bool verticalScrollBar = true ),
  systemScrollBoxLength    ( bool verticalScrollBar = true ),
  systemScrollButtonLength ( bool verticalScrollBar = true );

/*--------------------------- Query Operations -------------------------------*/
bool
  isHorizontal ( ) const,
  isVertical   ( ) const;

/*------------------------- Manipulation Operations --------------------------*/
virtual IScrollBar
 &setScrollableRange ( const IRange& minMax ),
 &setVisibleCount    ( unsigned long scrollableRangeUnits ),
 &setScrollBar       ( const IRange& scrollableRange,
                       unsigned long visibleCount );
virtual IScrollBar
 &moveScrollBoxTo    ( unsigned long firstItem = 1 );

#ifdef IC_MOTIF
virtual IScrollBar
 &setPrevScrollBoxPosition ( unsigned long value );
#endif

virtual IRange
  scrollableRange     ( ) const,
  scrollBoxRange      ( ) const;
virtual unsigned long
  visibleCount        ( ) const,
  scrollBoxPosition   ( ) const;

#ifdef IC_MOTIF
virtual unsigned long
  prevScrollBoxPosition ( ) const;
#endif

/*--------------------------- Scrolling Increment ----------------------------*/
virtual unsigned long
  minScrollIncrement     ( ) const,
  pageScrollIncrement    ( ) const;
virtual IScrollBar
 &setMinScrollIncrement  ( unsigned long scrollableRangeUnits = 1 ),
 &setPageScrollIncrement ( unsigned long scrollableRangeUnits = 0 );

/*---------------------------------- Colors ----------------------------------*/
virtual IColor
  foregroundColor       () const,
  hiliteForegroundColor () const;

/*-------------------------------- Overrides ---------------------------------*/
#ifdef IC_MOTIF
virtual IScrollBar
  &setForegroundColor       ( const IColor &color),
  &setHiliteForegroundColor ( const IColor &color);

virtual IScrollBar
  &resetForegroundColor       (),
  &resetHiliteForegroundColor ();

bool
  isVisible  ( ) const;
#endif

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU scrollBoxChangeId,
  IC_IMPORTU scrollBoxTrackId;

/*----------------------- Observer Notification ------------------------------*/
virtual IScrollBar
 &enableNotification ( bool enable=true );


protected:
/*--------------------------- Protected Overrides ----------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

/*---------------------- Event-Handling Implementation -----------------------*/
#ifdef IC_MOTIF
virtual bool
  passEventToOwner    ( IEvent& event );
#endif

#ifdef IC_MOTIF
virtual IScrollBar
 &setColor ( unsigned long colorArea,
             const IColor &color);
#endif // IC_MOTIF

private:
/*------------------------------ Hidden Members ------------------------------*/
  IScrollBar            ( const IScrollBar& scrollBar );
IScrollBar
 &operator=             ( const IScrollBar& scrollBar );

/*--------------------------------- Private ----------------------------------*/
friend class IScrollBarData;
#ifdef IC_WIN
friend class IScrollBarHandler;
#endif //IC_WIN

#ifdef IC_PMWIN
void
  initialize( unsigned long     windowId,
              IWindow*          parent,
              IWindow*          owner,
              const IRectangle& initial,
              const IRange&     scrollableItems,
              unsigned long     visibleItemCount,
              unsigned long     scrollBoxPosition,
              const Style&      style );

unsigned long
  ulClMinScrollIncrement,
  ulClPageScrollIncrement;
#endif

#ifdef IC_WIN
void
  initializeControlData ( const IRange& scrollableItems,
                          unsigned long visibleItemCount,
                          struct tagSCROLLINFO* controlData );
#endif
#ifdef IC_PM
void
  initializeControlData ( const IRange& scrollableItems,
                          unsigned long visibleItemCount,
                          struct _SBCDATA* controlData ),
  windowData            ( struct _WNDPARAMS* windowData ) const;
#endif

static Style
  currentDefaultStyle;

IScrollBarData
 *fScrollBarData;

/*----------------------------- Obsolete Members -----------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
public:
static INotificationId const
  IC_IMPORTU scrollBoxPositionId;
#endif // IC_OBSOLETE

#ifdef IC_PM
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
static const Style
  IC_IMPORTU autoSize;
#endif
#endif
}; // IScrollBar

INESTEDBITFLAGCLASSFUNCS(Style, IScrollBar)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iscroll.inl>

#endif /* _ISCROLL_ */

