// Revision: 64 1.5 source/ui/baseapp/iscrlhdr.hpp, slidectls, ioc.v400, 980918 
#ifndef _ISCRLHDR_
  #define _ISCRLHDR_
/*******************************************************************************
* FILE NAME: iscrlhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IScrollHandler                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <iscrlevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IScrollHandlerPrivateData;

#pragma enum(4)
#pragma pack(push,4)

class IScrollHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IScrollHandler ( );
virtual
 ~IScrollHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  lineUp            ( IScrollEvent& event ),
  lineDown          ( IScrollEvent& event ),
  pageUp            ( IScrollEvent& event ),
  pageDown          ( IScrollEvent& event ),
  lineLeft          ( IScrollEvent& event ),
  lineRight         ( IScrollEvent& event ),
  pageLeft          ( IScrollEvent& event ),
  pageRight         ( IScrollEvent& event ),
  scrollBoxTrack    ( IScrollEvent& event ),
  scrollBoxTrackEnd ( IScrollEvent& event ),
  scrollEnd         ( IScrollEvent& event );

/*------------------------------ Implementation ------------------------------*/
virtual IScrollHandler
 &moveScrollBox ( IScrollEvent& event );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IScrollHandler ( const IScrollHandler &scrollHandler );
IScrollHandler
 &operator=      ( const IScrollHandler &scrollHandler );

/*--------------------------------- Private ----------------------------------*/
#ifdef IC_MOTIF
IScrollHandlerPrivateData
  *pData;
#endif
}; // IScrollHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ISCRLHDR_ */
