// Revision: 62 1.5 source/ui/baseapp/iscrlevt.hpp, slidectls, ioc.v400, 980918 
#ifndef _ISCRLEVT_
  #define _ISCRLEVT_
/*******************************************************************************
* FILE NAME: iscrlevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IScrollEvent                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IScrollBar;

#pragma enum(4)
#pragma pack(push,4)

class IScrollEvent : public IEvent {
typedef IEvent
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IScrollEvent ( const IEvent& event );

virtual
 ~IScrollEvent ( );

/*-------------------------------- Accessors ---------------------------------*/
IScrollBar*
  scrollBarWindow      ( ) const;
long
  scrollAmount         ( ) const;
unsigned long
  newScrollBoxPosition ( ) const;


private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
  ulClPrevScrollBoxPos;
};


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ISCRLEVT_ */
