// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 93 1.5.1.4 source/core/collect/isbtab.h, collection, ioc.v400, 980918 
#ifndef _ISBTAB_
#define _ISBTAB_

#include <ilanglvl.hpp>
#include <iasb.h>
#include <iicsb.h>

#include <iivsb.h>

#include <iisbtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedBagAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedBagAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedBagAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsTableCursor
                            (IGSortedBagAsTable
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsTableCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedBagAsTable :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsTable <Element, ElementOps> Self;

  typedef  ISortedBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsTableTypedef(Element, ElementOps)\
  typedef  ISortedBagAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedBagAsTableCursor
            <Element, ElementOps> Cursor;




           IGSortedBagAsTable
                            (INumber = 100);

           IGSortedBagAsTable
                            (IGSortedBagAsTable
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsTable <Element, ElementOps>&
           operator=        (IGSortedBagAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedBagAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedBagAsTable :
  public IGSortedBagAsTable
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedBagAsTable <Element> Self;

#define ISortedBagAsTableTypedef(Element)\
  typedef  ISortedBagAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedBagAsTable
                            (INumber = 100);

















protected:

           ISortedBagAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedBagAsTable :
  public IGSortedBagAsTable
          <Element, ElementOps > {

  typedef  IVGSortedBagAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedBagAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsTableTypedef(Element, ElementOps)\
  typedef  ISortedBagAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedBagAsTable
                            (INumber = 100);

















protected:

           IVGSortedBagAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedBagAsTable :
  public IVGSortedBagAsTable
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedBagAsTable <Element> Self;

#define IVSortedBagAsTableTypedef(Element)\
  typedef  IVSortedBagAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedBagAsTable
                            (INumber = 100);

















protected:

           IVSortedBagAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isbtab.inl>


#pragma info (restore)


#endif // _ISBTAB_
