// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 88 1.5.1.4 source/core/collect/isblst.h, collection, ioc.v400, 980918 
#ifndef _ISBLST_
#define _ISBLST_

#include <ilanglvl.hpp>
#include <iasb.h>
#include <iicsb.h>

#include <iivsb.h>

#include <iisblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedBagAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedBagAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedBagAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsListCursor
                            (IGSortedBagAsList
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsListCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedBagAsList :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsList <Element, ElementOps> Self;

  typedef  ISortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsListTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedBagAsListCursor
            <Element, ElementOps> Cursor;




           IGSortedBagAsList
                            (INumber = 100);

           IGSortedBagAsList
                            (IGSortedBagAsList
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsList <Element, ElementOps>&
           operator=        (IGSortedBagAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedBagAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsListCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedBagAsList :
  public IGSortedBagAsList
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedBagAsList <Element> Self;

#define ISortedBagAsListTypedef(Element)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedBagAsList
                            (INumber = 100);

















protected:

           ISortedBagAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedBagAsList :
  public IGSortedBagAsList
          <Element, ElementOps > {

  typedef  IVGSortedBagAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedBagAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsListTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedBagAsList
                            (INumber = 100);

















protected:

           IVGSortedBagAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedBagAsList :
  public IVGSortedBagAsList
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedBagAsList <Element> Self;

#define IVSortedBagAsListTypedef(Element)\
  typedef  IVSortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedBagAsList
                            (INumber = 100);

















protected:

           IVSortedBagAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isblst.inl>


#pragma info (restore)


#endif // _ISBLST_
