// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 86 1.5.1.4 source/core/collect/isbdil.h, collection, ioc.v400, 980918 
#ifndef _ISBDIL_
#define _ISBDIL_

#include <ilanglvl.hpp>
#include <iasb.h>
#include <iicsb.h>

#include <iivsb.h>

#include <iisbdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedBagAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedBagAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedBagAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsDilTableCursor
                            (IGSortedBagAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsDilTableCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedBagAsDilTable :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsDilTable <Element, ElementOps> Self;

  typedef  ISortedBagAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsDilTableTypedef(Element, ElementOps)\
  typedef  ISortedBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedBagAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGSortedBagAsDilTable
                            (INumber = 100);

           IGSortedBagAsDilTable
                            (IGSortedBagAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsDilTable <Element, ElementOps>&
           operator=        (IGSortedBagAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedBagAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedBagAsDilTable :
  public IGSortedBagAsDilTable
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedBagAsDilTable <Element> Self;

#define ISortedBagAsDilTableTypedef(Element)\
  typedef  ISortedBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedBagAsDilTable
                            (INumber = 100);

















protected:

           ISortedBagAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedBagAsDilTable :
  public IGSortedBagAsDilTable
          <Element, ElementOps > {

  typedef  IVGSortedBagAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedBagAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsDilTableTypedef(Element, ElementOps)\
  typedef  ISortedBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedBagAsDilTable
                            (INumber = 100);

















protected:

           IVGSortedBagAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedBagAsDilTable :
  public IVGSortedBagAsDilTable
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedBagAsDilTable <Element> Self;

#define IVSortedBagAsDilTableTypedef(Element)\
  typedef  IVSortedBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedBagAsDilTable
                            (INumber = 100);

















protected:

           IVSortedBagAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isbdil.inl>


#pragma info (restore)


#endif // _ISBDIL_
