// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 84 1.5.1.4 source/core/collect/isbbst.h, collection, ioc.v400, 980918 
#ifndef _ISBBST_
#define _ISBBST_

#include <ilanglvl.hpp>
#include <iasb.h>
#include <iicsb.h>

#include <iivsb.h>

#include <iisblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedBagAsBstTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedBagAsBstTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedBagAsBstTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsBstTreeCursor
                            (IGSortedBagAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsBstTreeCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsBstTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsBstTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedBagAsBstTree :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsBstTree <Element, ElementOps> Self;

  typedef  ISortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsBstTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedBagAsBstTreeCursor
            <Element, ElementOps> Cursor;




           IGSortedBagAsBstTree
                            (INumber = 100);

           IGSortedBagAsBstTree
                            (IGSortedBagAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsBstTree <Element, ElementOps>&
           operator=        (IGSortedBagAsBstTree
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedBagAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsBstTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsBstTreeCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedBagAsBstTree :
  public IGSortedBagAsBstTree
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedBagAsBstTree <Element> Self;

#define ISortedBagAsBstTreeTypedef(Element)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedBagAsBstTree
                            (INumber = 100);

















protected:

           ISortedBagAsBstTree
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedBagAsBstTree :
  public IGSortedBagAsBstTree
          <Element, ElementOps > {

  typedef  IVGSortedBagAsBstTree
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedBagAsBstTree
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsBstTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedBagAsBstTree
                            (INumber = 100);

















protected:

           IVGSortedBagAsBstTree
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedBagAsBstTree :
  public IVGSortedBagAsBstTree
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedBagAsBstTree <Element> Self;

#define IVSortedBagAsBstTreeTypedef(Element)\
  typedef  IVSortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedBagAsBstTree
                            (INumber = 100);

















protected:

           IVSortedBagAsBstTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isbbst.inl>


#pragma info (restore)


#endif // _ISBBST_
