// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 82 1.5.1.4 source/core/collect/isbavl.h, collection, ioc.v400, 980918 
#ifndef _ISBAVL_
#define _ISBAVL_

#include <ilanglvl.hpp>
#include <iasb.h>
#include <iicsb.h>

#include <iivsb.h>

#include <iisblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedBagAsAvlTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedBagAsAvlTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedBagAsAvlTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsAvlTreeCursor
                            (IGSortedBagAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsAvlTreeCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsAvlTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsAvlTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedBagAsAvlTree :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsAvlTree <Element, ElementOps> Self;

  typedef  ISortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedBagAsAvlTreeCursor
            <Element, ElementOps> Cursor;




           IGSortedBagAsAvlTree
                            (INumber = 100);

           IGSortedBagAsAvlTree
                            (IGSortedBagAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsAvlTree <Element, ElementOps>&
           operator=        (IGSortedBagAsAvlTree
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedBagAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsAvlTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsAvlTreeCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedBagAsAvlTree :
  public IGSortedBagAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedBagAsAvlTree <Element> Self;

#define ISortedBagAsAvlTreeTypedef(Element)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedBagAsAvlTree
                            (INumber = 100);

















protected:

           ISortedBagAsAvlTree
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedBagAsAvlTree :
  public IGSortedBagAsAvlTree
          <Element, ElementOps > {

  typedef  IVGSortedBagAsAvlTree
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedBagAsAvlTree
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedBagAsAvlTree
                            (INumber = 100);

















protected:

           IVGSortedBagAsAvlTree
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedBagAsAvlTree :
  public IVGSortedBagAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedBagAsAvlTree <Element> Self;

#define IVSortedBagAsAvlTreeTypedef(Element)\
  typedef  IVSortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedBagAsAvlTree
                            (INumber = 100);

















protected:

           IVSortedBagAsAvlTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isbavl.inl>


#pragma info (restore)


#endif // _ISBAVL_
