// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 80 1.5.1.4 source/core/collect/isb.h, collection, ioc.v400, 980918 
#ifndef _ISB_
#define _ISB_

#include <ilanglvl.hpp>
#include <iasb.h>
#include <iicsb.h>

#include <iivsb.h>

#include <iisblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedBag;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedBagCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedBag
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagCursor
                            (IGSortedBag
                              <
                               Element, ElementOps> const&);

  IGSortedBagCursor <Element, ElementOps>&
           operator=        (IGSortedBagCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedBag :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBag <Element, ElementOps> Self;

  typedef  ISortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedBagCursor
            <Element, ElementOps> Cursor;




           IGSortedBag
                            (INumber = 100);

           IGSortedBag
                            (IGSortedBag
                              <
                               Element, ElementOps> const&);

  IGSortedBag <Element, ElementOps>&
           operator=        (IGSortedBag
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedBag
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBag
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedBag :
  public IGSortedBag
          <Element, ICOps <Element> > {

  typedef  IGSortedBag
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedBag <Element> Self;

#define ISortedBagTypedef(Element)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedBag
                            (INumber = 100);

















protected:

           ISortedBag
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedBag :
  public IGSortedBag
          <Element, ElementOps > {

  typedef  IVGSortedBag
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedBag
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedBag
                            (INumber = 100);

















protected:

           IVGSortedBag
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedBag :
  public IVGSortedBag
          <Element, ICOps <Element> > {

  typedef  IVGSortedBag
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedBag <Element> Self;

#define IVSortedBagTypedef(Element)\
  typedef  IVSortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedBag
                            (INumber = 100);

















protected:

           IVSortedBag
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isb.inl>


#pragma info (restore)


#endif // _ISB_
