// Revision: 71 1.12.1.5 source/core/base/ireslock.hpp, oss, ioc.v400, 980918 
// ----------------------------------------------------------------------------
// FILE NAME: ireslock.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IResource
//     IPrivateResource
//     ISharedResource
//     IResourceLock
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
//
// ----------------------------------------------------------------------------

#ifndef _IRESLOCK_
#define _IRESLOCK_

#include <ibase.hpp>
#include <ibhandle.hpp>

#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IResourceLock;
class IPrivateResource;
class ISharedResource;

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB IResource 
{
public:
    //------------------------------- Constructors ---------------------------
    IResource();
    virtual ~IResource();

    // ----------------------------- Resource Locking ------------------------
    virtual IResource& lock(long timeOut = -1) = 0;
    virtual IResource& unlock() = 0;

protected:
    //-------------------------- Condition Operations ------------------------
    long unlockAll();
    void relockAll(long times);

private:
    // ------------------------------ Hidden Members --------------------------
    IResource(const IResource& resource);
    IResource &operator=(const IResource& resource);

    // --------------------------------- Private ------------------------------
    void* lockingThread;
    long  recursionCount;

    friend class ICondition;
    friend class IResourceLock;
    friend class IPrivateResource;
    friend class ISharedResource;
};


class IC_EXPORTB IPrivateResource : public IResource
{
    typedef IResource Inherited;
public:
    // ------------------------------- Constructors ---------------------------
    IPrivateResource();
    virtual ~IPrivateResource();

    // ----------------------------- Resource Locking -------------------------
    virtual IPrivateResource& lock(long timeOut = -1);
    virtual IPrivateResource& unlock();


protected:
    // ------------------------------ Resource Handle -------------------------
    IPrivateSemaphoreHandle& handle();

private:
    // ------------------------------ Hidden Members --------------------------
    IPrivateResource(const IPrivateResource& privateResource);
    IPrivateResource &operator=(const IPrivateResource& privateResource);

    // --------------------------------- Private ------------------------------
    IPrivateSemaphoreHandle resourceHandleCl;

    friend class IResourceLock;
};


class IC_EXPORTB ISharedResource : public IResource
{
    typedef IResource Inherited;
public:
    // ------------------------------- Constructors ---------------------------
    ISharedResource(const char* keyName);
    virtual ~ISharedResource();

    // ---------------------------- Resource Information ----------------------
    IString keyName() const;


    // ----------------------------- Resource Locking -------------------------
    virtual ISharedResource& lock(long timeOut = -1);
    virtual ISharedResource& unlock();

protected:
    // ------------------------------ Resource Handle -------------------------
    ISharedSemaphoreHandle& handle();

private:
    // ------------------------------ Hidden Members --------------------------
    ISharedResource(const ISharedResource& sharedResource);
    ISharedResource &operator=(const ISharedResource& sharedResource);

    // --------------------------------- Private ------------------------------
    ISharedSemaphoreHandle resourceHandleCl;
    IString keyNameCl;

    friend class IResourceLock;
};

class IC_EXPORTB IResourceLock 
{
public:
    // ------------------------------- Constructors ---------------------------
    IResourceLock( IResource& resource, long timeOut = -1);
    virtual ~IResourceLock();

protected:
    // ----------------------------- Resource Locking -------------------------
    virtual IResourceLock& setLock(long timeOut = -1);
    virtual IResourceLock& clearLock();

private:
    // ------------------------------ Hidden Members --------------------------
    IResourceLock(const IResourceLock& resourceLock);
    IResourceLock& operator=(const IResourceLock& resourceLock);

    // --------------------------------- Private ------------------------------
    IResource* presCl;

    friend class ICondition;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ireslock.inl>

#endif
