// Revision: 54 1.13.1.7 source/ui/baseapp/ireslib.hpp, resource, ioc.v400, 980918 
#ifndef _IRESLIB_
#define _IRESLIB_
/*******************************************************************************
* FILE NAME: ireslib.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IResourceLibrary                                                         *
*     IDynamicLinkLibrary                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ihandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IDLLModule;
class ISize;
class IWindow;
class IMenu;
class IResLibPrivateData;
class IDynLinkLibPrivateData;
class IDLLModule;

#pragma enum(4)
#pragma pack(push,4)

class IResourceLibrary  {
public:
/*------------------------------- Constructors -------------------------------*/
  IResourceLibrary   ( );
  IResourceLibrary   ( const IResourceLibrary& resLibrary );
virtual
 ~IResourceLibrary   ( );

IResourceLibrary
 &operator=           ( const IResourceLibrary& resLibrary );

/*---------------------------- Resource Information --------------------------*/
virtual IString
  fileName           ( ) const;

virtual bool
  isOpen             ( ) const;

virtual IModuleHandle
  handle             ( ) const;

/*-------------------------------- Diagnostics -------------------------------*/
virtual IString
  asString           ( ) const,
  asDebugInfo        ( ) const;


/*------------------------------ Resource Loading ----------------------------*/
virtual IString
  loadString      ( unsigned long stringId  ) const,
  loadMessage     ( unsigned long messageId ) const;

#ifdef IC_PMWIN
virtual IMenuHandle
  loadMenu        ( unsigned long menuId,
                    IWindow*      menuOwner ) const;

virtual IWindowHandle
  loadDialog      ( unsigned long dialogId,
                    IWindow*      dialogParent,
                    IWindow*      dialogOwner,
                    IWinProc*     dialogProcedure,
                    void*         dialogCreateParameters ) const;
#endif  // IC_PMWIN

#ifdef IC_MOTIF
virtual void
  loadMenu        ( unsigned long        menuId,
                    const IWindowHandle& menuHandle,
                    IMenu*               parentMenu ) const;
#endif // IC_MOTIF

virtual IAccelTblHandle
  loadAccelTable  ( unsigned long accelTableId ) const;

virtual IResourceLibrary
 &loadHelpTable   ( IWindow*      helpInstance,
                    unsigned long helpTableId ) const;

virtual IPointerHandle
  loadIcon        ( unsigned long iconId,
                    bool       cached = true ) const,
  loadPointer     ( unsigned long iconId,
                    bool       cached = true ) const;

virtual IBitmapHandle
  loadBitmap      ( unsigned long bitmapId,
                    bool       cached = true ) const,
  loadBitmap      ( unsigned long bitmapId,
                    const ISize&  bitmapSize,
                    bool       cached = true ) const;

virtual IString
  tryToLoadString      ( unsigned long stringId  ) const,
  tryToLoadMessage     ( unsigned long messageId ) const;

virtual IPointerHandle
  tryToLoadIcon        ( unsigned long iconId,
                         bool       cached = true ) const,
  tryToLoadPointer     ( unsigned long iconId,
                         bool       cached = true ) const;

virtual IBitmapHandle
  tryToLoadBitmap     ( unsigned long bitmapId,
                        bool       cached = true ) const,
  tryToLoadBitmap     ( unsigned long bitmapId,
                        const ISize&  bitmapSize,
                        bool       cached = true ) const;

protected:

#ifdef IC_MOTIF
virtual void
 *resourceAddress ( ) const;
#endif

private:
/*-------------------------------- Private -----------------------------------*/
IString
 loadText        ( bool       isString,
                   unsigned long stringID,
                   bool       throwException = true ) const;

IResLibPrivateData
 *fExtendedData;

IModuleHandle
  fModuleHandle;

#ifdef IC_MOTIF
friend class IAixResourceImp;
#endif

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  #ifdef IC_MOTIF
  public:
  virtual void
    loadAccelTable  ( unsigned long        accelTableId,
                      const IWindowHandle& menu ) const;
  #endif // IC_MOTIF
#endif

};  // IResourceLibrary


class IDynamicLinkLibrary : public IResourceLibrary
{
typedef IResourceLibrary
  Inherited;
public:
enum ESearchLocation { kOSDefaultSearch, kNLSPathSearch };
/*------------------------------- Constructors -------------------------------*/
  IDynamicLinkLibrary   ( const char*                fileName,
                          ESearchLocation            searchLocation = kOSDefaultSearch );
#ifndef IC_MOTIF
  IDynamicLinkLibrary   ( const IModuleHandle&       moduleHandle );
#endif
  IDynamicLinkLibrary   ( const IDynamicLinkLibrary& dllLibrary );

virtual
  ~IDynamicLinkLibrary  ( );

IDynamicLinkLibrary
 &operator=             ( const IDynamicLinkLibrary& dllLibrary );

/*-------------------------- Opening and Closing -----------------------------*/
virtual IDynamicLinkLibrary
 &open                ( ),
 &close               ( );

/*----------------------- Procedure Address Loading --------------------------*/
void
 *procAddress       ( const char*   procedureName ) const;
#ifndef IC_MOTIF
void
 *procAddress       ( unsigned long procedureOrdinal ) const;
#endif


#ifndef IC_MOTIF
bool
  isEntryPoint32Bit ( const char*   procedureName ) const,
  isEntryPoint32Bit ( unsigned long procedureOrdinal ) const;
#endif

/*--------------------- Dynamic Link Library Information ---------------------*/
virtual bool
  isOpen           ( ) const;

virtual IString
  fileName         ( ) const;

virtual IModuleHandle
  handle           ( ) const;

/*-------------------------------- Diagnostics -------------------------------*/
virtual IString
  asString         ( ) const,
  asDebugInfo      ( ) const;


protected:

#ifdef IC_MOTIF
virtual void
 *resourceAddress ( ) const;
#endif

private:
/*-------------------------------- Private -----------------------------------*/

IDLLModule
 *fDLLModule;

IDynLinkLibPrivateData
 *fPrivateData;
};


class IResourceId
{
public:
/*------------------------------- Constructors -------------------------------*/
  IResourceId      ( unsigned long              resourceId,
                     const IResourceLibrary&    resourceLibrary );

  IResourceId      ( unsigned long              resourceId );

  IResourceId      ( const IResourceId&         resourceId );

/*--------------------------------- Resources --------------------------------*/
unsigned long
  id                    ( ) const;

operator unsigned long  ( ) const;

const IResourceLibrary
 &resourceLibrary       ( ) const;

/*-------------------------------- Diagnostics -------------------------------*/
IString
  asString         ( ) const,
  asDebugInfo      ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
IResourceId
  &operator=    ( const IResourceId& resourceId );

/*--------------------------------- Private ----------------------------------*/
unsigned long
  fResId;

const IResourceLibrary
 &fResLibrary;

}; // IResourceId


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ireslib.inl>

#endif // _IRESLIB_
