// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 44 1.5.1.4 source/core/collect/ireltab.h, collection, ioc.v400, 980918 
#ifndef _IRELTAB_
#define _IRELTAB_

#include <ilanglvl.hpp>
#include <iarel.h>
#include <iicrel.h>

#include <iivrel.h>

#include <iireltab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGRelationAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGRelationAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGRelationAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationAsTableCursor
                            (IGRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGRelationAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGRelationAsTable :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelationAsTable <Element, Key, ElementOps> Self;

  typedef  IRelationAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationAsTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGRelationAsTableCursor
            <Element, Key, ElementOps> Cursor;




           IGRelationAsTable
                            (INumber = 100);

           IGRelationAsTable
                            (IGRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsTable <Element, Key, ElementOps>&
           operator=        (IGRelationAsTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGRelationAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationAsTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IRelationAsTable :
  public IGRelationAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGRelationAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IRelationAsTable <Element, Key> Self;

#define IRelationAsTableTypedef(Element, Key)\
  typedef  IRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IRelationAsTable
                            (INumber = 100);

















protected:

           IRelationAsTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGRelationAsTable :
  public IGRelationAsTable
          <Element, Key, ElementOps > {

  typedef  IVGRelationAsTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGRelationAsTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationAsTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGRelationAsTable
                            (INumber = 100);

















protected:

           IVGRelationAsTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVRelationAsTable :
  public IVGRelationAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGRelationAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVRelationAsTable <Element, Key> Self;

#define IVRelationAsTableTypedef(Element, Key)\
  typedef  IVRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVRelationAsTable
                            (INumber = 100);

















protected:

           IVRelationAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ireltab.inl>


#pragma info (restore)


#endif // _IRELTAB_
