// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 42 1.5.1.4 source/core/collect/irellst.h, collection, ioc.v400, 980918 
#ifndef _IRELLST_
#define _IRELLST_

#include <ilanglvl.hpp>
#include <iarel.h>
#include <iicrel.h>

#include <iivrel.h>

#include <iirellst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGRelationAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGRelationAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGRelationAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationAsListCursor
                            (IGRelationAsList
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsListCursor <Element, Key, ElementOps>&
           operator=        (IGRelationAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGRelationAsList :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelationAsList <Element, Key, ElementOps> Self;

  typedef  IRelationAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationAsListTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGRelationAsListCursor
            <Element, Key, ElementOps> Cursor;




           IGRelationAsList
                            (INumber = 100);

           IGRelationAsList
                            (IGRelationAsList
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsList <Element, Key, ElementOps>&
           operator=        (IGRelationAsList
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGRelationAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelationAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationAsListCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IRelationAsList :
  public IGRelationAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGRelationAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IRelationAsList <Element, Key> Self;

#define IRelationAsListTypedef(Element, Key)\
  typedef  IRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IRelationAsList
                            (INumber = 100);

















protected:

           IRelationAsList
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGRelationAsList :
  public IGRelationAsList
          <Element, Key, ElementOps > {

  typedef  IVGRelationAsList
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGRelationAsList
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationAsListTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGRelationAsList
                            (INumber = 100);

















protected:

           IVGRelationAsList
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVRelationAsList :
  public IVGRelationAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGRelationAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVRelationAsList <Element, Key> Self;

#define IVRelationAsListTypedef(Element, Key)\
  typedef  IVRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVRelationAsList
                            (INumber = 100);

















protected:

           IVRelationAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <irellst.inl>


#pragma info (restore)


#endif // _IRELLST_
