// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 40 1.5.1.4 source/core/collect/irelhsh.h, collection, ioc.v400, 980918 
#ifndef _IRELHSH_
#define _IRELHSH_

#include <ilanglvl.hpp>
#include <iarel.h>
#include <iicrel.h>

#include <iivrel.h>

#include <iirelhsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGRelationAsHshTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGRelationAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGRelationAsHshTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationAsHshTableCursor
                            (IGRelationAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsHshTableCursor <Element, Key, ElementOps>&
           operator=        (IGRelationAsHshTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationAsHshTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGRelationAsHshTable :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelationAsHshTable <Element, Key, ElementOps> Self;

  typedef  IRelationAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGRelationAsHshTableCursor
            <Element, Key, ElementOps> Cursor;




           IGRelationAsHshTable
                            (INumber = 100);

           IGRelationAsHshTable
                            (IGRelationAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsHshTable <Element, Key, ElementOps>&
           operator=        (IGRelationAsHshTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGRelationAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelationAsHshTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationAsHshTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IRelationAsHshTable :
  public IGRelationAsHshTable
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IGRelationAsHshTable
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IRelationAsHshTable <Element, Key> Self;

#define IRelationAsHshTableTypedef(Element, Key)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IRelationAsHshTable
                            (INumber = 100);

















protected:

           IRelationAsHshTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGRelationAsHshTable :
  public IGRelationAsHshTable
          <Element, Key, ElementOps > {

  typedef  IVGRelationAsHshTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGRelationAsHshTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGRelationAsHshTable
                            (INumber = 100);

















protected:

           IVGRelationAsHshTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVRelationAsHshTable :
  public IVGRelationAsHshTable
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IVGRelationAsHshTable
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVRelationAsHshTable <Element, Key> Self;

#define IVRelationAsHshTableTypedef(Element, Key)\
  typedef  IVRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVRelationAsHshTable
                            (INumber = 100);

















protected:

           IVRelationAsHshTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <irelhsh.inl>


#pragma info (restore)


#endif // _IRELHSH_
