// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 37 1.5.1.4 source/core/collect/ireldil.h, collection, ioc.v400, 980918 
#ifndef _IRELDIL_
#define _IRELDIL_

#include <ilanglvl.hpp>
#include <iarel.h>
#include <iicrel.h>

#include <iivrel.h>

#include <iireldil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGRelationAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGRelationAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGRelationAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationAsDilTableCursor
                            (IGRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGRelationAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGRelationAsDilTable :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelationAsDilTable <Element, Key, ElementOps> Self;

  typedef  IRelationAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGRelationAsDilTableCursor
            <Element, Key, ElementOps> Cursor;




           IGRelationAsDilTable
                            (INumber = 100);

           IGRelationAsDilTable
                            (IGRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsDilTable <Element, Key, ElementOps>&
           operator=        (IGRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGRelationAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationAsDilTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IRelationAsDilTable :
  public IGRelationAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGRelationAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IRelationAsDilTable <Element, Key> Self;

#define IRelationAsDilTableTypedef(Element, Key)\
  typedef  IRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IRelationAsDilTable
                            (INumber = 100);

















protected:

           IRelationAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGRelationAsDilTable :
  public IGRelationAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGRelationAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGRelationAsDilTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGRelationAsDilTable
                            (INumber = 100);

















protected:

           IVGRelationAsDilTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVRelationAsDilTable :
  public IVGRelationAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGRelationAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVRelationAsDilTable <Element, Key> Self;

#define IVRelationAsDilTableTypedef(Element, Key)\
  typedef  IVRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVRelationAsDilTable
                            (INumber = 100);

















protected:

           IVRelationAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ireldil.inl>


#pragma info (restore)


#endif // _IRELDIL_
