// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 35 1.5.1.4 source/core/collect/irel.h, collection, ioc.v400, 980918 
#ifndef _IREL_
#define _IREL_

#include <ilanglvl.hpp>
#include <iarel.h>
#include <iicrel.h>

#include <iivrel.h>

#include <iirelhsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGRelation;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGRelationCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGRelation
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationCursor
                            (IGRelation
                              <
                               Element, Key, ElementOps> const&);

  IGRelationCursor <Element, Key, ElementOps>&
           operator=        (IGRelationCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGRelation :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelation <Element, Key, ElementOps> Self;

  typedef  IRelationAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGRelationCursor
            <Element, Key, ElementOps> Cursor;




           IGRelation
                            (INumber = 100);

           IGRelation
                            (IGRelation
                              <
                               Element, Key, ElementOps> const&);

  IGRelation <Element, Key, ElementOps>&
           operator=        (IGRelation
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGRelation
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelation
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IRelation :
  public IGRelation
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IGRelation
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IRelation <Element, Key> Self;

#define IRelationTypedef(Element, Key)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IRelation
                            (INumber = 100);

















protected:

           IRelation
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGRelation :
  public IGRelation
          <Element, Key, ElementOps > {

  typedef  IVGRelation
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGRelation
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGRelation
                            (INumber = 100);

















protected:

           IVGRelation
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVRelation :
  public IVGRelation
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IVGRelation
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVRelation <Element, Key> Self;

#define IVRelationTypedef(Element, Key)\
  typedef  IVRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVRelation
                            (INumber = 100);

















protected:

           IVRelation
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <irel.inl>


#pragma info (restore)


#endif // _IREL_
