// Revision: 30 1.5.1.3 source/ui/basectl/iradiobt.hpp, buttonctls, ioc.v400, 980918  
#ifndef _IRADIOBT_
  #define _IRADIOBT_
/*******************************************************************************
* FILE NAME: iradiobt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IRadioButton                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <isetbut.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISize;
class IWindowHandle;
class IRadioButtonData;

#pragma enum(4)
#pragma pack(push,4)

class IRadioButton : public ISettingButton  {
typedef ISettingButton
  Inherited;
public:

class Style;

/*------------------------------- Constructors -------------------------------*/
  IRadioButton ( unsigned long id,
                 IWindow* parent,
                 IWindow* owner,
                 const IRectangle& initial= IRectangle(),
                 const Style& style = defaultStyle() );

  IRadioButton ( unsigned long id,
                 IWindow*      parent );

  IRadioButton ( const IWindowHandle& handle );

virtual
 ~IRadioButton ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3( Style,
                         IRadioButton,
                         IWindow,
                         IControl,
                         IButton );

static const Style
  IC_IMPORTU classDefaultStyle,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU noCursorSelect,
#endif
  IC_IMPORTU autoSelect;

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style);

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;


/*------------------------------- Auto Select --------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IRadioButton
  &enableAutoSelect    ( bool enable=true ),
  &disableAutoSelect   ( );
virtual bool
  isAutoSelect         ( ) const;
#endif  // IC_MOTIF_FLAGNOP

/*----------------------------- Style Functions ------------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IRadioButton
  &enableCursorSelect  ( bool enable=true ),
  &disableCursorSelect ( );
bool
  isCursorSelect       ( ) const;
#endif

/*-------------------------------- Selection ---------------------------------*/
static const unsigned long
  IC_IMPORTU noSelections;
unsigned long
  selectedIndex        ( ) const;

protected:
/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize      ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
#ifdef IC_WIN
friend class IRadioHandler;
#endif //IC_WIN

static Style
  currentDefaultStyle;

IRadioButtonData
 *fRadioButtonData;

/*----------------------------- Hidden Functions -----------------------------*/
  IRadioButton         ( const IRadioButton& );
IRadioButton
 &operator=            ( const IRadioButton& );
};  // class IRadioButton

INESTEDBITFLAGCLASSFUNCS( Style, IRadioButton )

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  // _IRADIOBT_
