// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 29 1.5.1.4 source/core/collect/iqutab.h, collection, ioc.v400, 980918 
#ifndef _IQUTAB_
#define _IQUTAB_

#include <ilanglvl.hpp>
#include <iaqu.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGQueueAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGQueueAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGQueueAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGQueueAsTableCursor
                            (IGQueueAsTable
                              <
                               Element, ElementOps> const&);

  IGQueueAsTableCursor <Element, ElementOps>&
           operator=        (IGQueueAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGQueueAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGQueueAsTable :
  public IAQueue <Element> {
protected:

  typedef  IGQueueAsTable <Element, ElementOps> Self;

  typedef  ISequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGQueueAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGQueueAsTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGQueueAsTableCursor
            <Element, ElementOps> Cursor;




           IGQueueAsTable
                            (INumber = 100);

           IGQueueAsTable
                            (IGQueueAsTable
                              <
                               Element, ElementOps> const&);

  IGQueueAsTable <Element, ElementOps>&
           operator=        (IGQueueAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGQueueAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGQueueAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGQueueAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class IQueueAsTable :
  public IGQueueAsTable
          <Element, IStdOps <Element> > {

  typedef  IGQueueAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IQueueAsTable <Element> Self;

#define IQueueAsTableTypedef(Element)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IQueueAsTable
                            (INumber = 100);

















protected:

           IQueueAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGQueueAsTable :
  public IGQueueAsTable
          <Element, ElementOps > {

  typedef  IVGQueueAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGQueueAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGQueueAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGQueueAsTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGQueueAsTable
                            (INumber = 100);

















protected:

           IVGQueueAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVQueueAsTable :
  public IVGQueueAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGQueueAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVQueueAsTable <Element> Self;

#define IVQueueAsTableTypedef(Element)\
  typedef  IVSequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVQueueAsTable
                            (INumber = 100);

















protected:

           IVQueueAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iqutab.inl>


#pragma info (restore)


#endif // _IQUTAB_
