// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 27 1.5.1.4 source/core/collect/iqulst.h, collection, ioc.v400, 980918 
#ifndef _IQULST_
#define _IQULST_

#include <ilanglvl.hpp>
#include <iaqu.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGQueueAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGQueueAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGQueueAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGQueueAsListCursor
                            (IGQueueAsList
                              <
                               Element, ElementOps> const&);

  IGQueueAsListCursor <Element, ElementOps>&
           operator=        (IGQueueAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGQueueAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGQueueAsList :
  public IAQueue <Element> {
protected:

  typedef  IGQueueAsList <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGQueueAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGQueueAsListTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGQueueAsListCursor
            <Element, ElementOps> Cursor;




           IGQueueAsList
                            (INumber = 100);

           IGQueueAsList
                            (IGQueueAsList
                              <
                               Element, ElementOps> const&);

  IGQueueAsList <Element, ElementOps>&
           operator=        (IGQueueAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGQueueAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGQueueAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGQueueAsListCursor <Element, ElementOps>;






















};

template <class Element>
class IQueueAsList :
  public IGQueueAsList
          <Element, IStdOps <Element> > {

  typedef  IGQueueAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IQueueAsList <Element> Self;

#define IQueueAsListTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IQueueAsList
                            (INumber = 100);

















protected:

           IQueueAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGQueueAsList :
  public IGQueueAsList
          <Element, ElementOps > {

  typedef  IVGQueueAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGQueueAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGQueueAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGQueueAsListTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGQueueAsList
                            (INumber = 100);

















protected:

           IVGQueueAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVQueueAsList :
  public IVGQueueAsList
          <Element, IStdOps <Element> > {

  typedef  IVGQueueAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVQueueAsList <Element> Self;

#define IVQueueAsListTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVQueueAsList
                            (INumber = 100);

















protected:

           IVQueueAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iqulst.inl>


#pragma info (restore)


#endif // _IQULST_
